/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministratorDerivedRoleTypeService;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.framework.role.RoleTypeService;

public class AwardAllUnitAdministratorDerivedRoleTypeServiceImpl
extends AbstractUnitAdministratorDerivedRoleTypeService
implements RoleTypeService {
    private UnitService unitService;
    private AwardService awardService;
    private ParameterService parameterService;

    @Override
    public List<? extends AbstractUnitAdministrator> getUnitAdministrators(Map<String, String> qualifiers) {
        String awardIdStr = qualifiers.get("award");
        boolean ascendsHierarchy = this.shouldAscendHierarchy(qualifiers);
        if (StringUtils.isNotBlank((CharSequence)awardIdStr) && awardIdStr.matches("\\d+")) {
            Long awardId = Long.valueOf(awardIdStr);
            Award award = this.getAwardService().getAward(awardId);
            List admins = award.getProjectPersons().stream().flatMap(p -> this.getUnitsForPerson((AwardPerson)p, ascendsHierarchy).stream()).distinct().flatMap(u -> this.unitService.retrieveUnitAdministratorsByUnitNumber((String)u).stream()).collect(Collectors.toList());
            return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "All", "Include_Derived_Unit_Contacts") != false ? Stream.of(Optional.ofNullable(admins).orElse(Collections.emptyList()), Optional.ofNullable(award.getAwardUnitContacts()).orElse(Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList()) : admins;
        }
        return new ArrayList();
    }

    protected Set<String> getUnitsForPerson(AwardPerson person, boolean ascendsHierarchy) {
        return person.getUnits().stream().map(AwardPersonUnit::getUnitNumber).distinct().flatMap(unitNumber -> {
            if (ascendsHierarchy) {
                return this.unitService.getUnitHierarchyForUnit((String)unitNumber).stream().map(Unit::getUnitNumber);
            }
            return Stream.of(unitNumber);
        }).collect(Collectors.toSet());
    }

    protected boolean shouldAscendHierarchy(Map<String, String> qualifiers) {
        String subunitsString = qualifiers.getOrDefault("subunits", "N");
        return "Y".equals(subunitsString) || "Yes".equals(subunitsString);
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

