/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.attachment.AttachmentDocumentStatus;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardDocumentRule;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncPendingChangeBean;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachment;
import org.kuali.kra.award.notesandattachments.notes.AwardNoteAddEvent;
import org.kuali.kra.award.notesandattachments.notes.AwardNoteEventBase;
import org.kuali.kra.award.notesandattachments.notes.AwardNotepadBean;
import org.kuali.kra.award.rule.event.AddAwardAttachmentEvent;
import org.kuali.kra.award.service.impl.AwardCommentServiceImpl;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;

public class AwardNotesAndAttachmentsAction
extends AwardAction {
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String CONFIRM_DELETE_ATTACHMENT = "confirmDeleteAttachment";
    private static final String CONFIRM_DELETE_ATTACHMENT_KEY = "confirmDeleteAttachmentKey";
    private static final String CONFIRM_VOID_ATTACHMENT = "confirmVoidAttachment";
    private static final String CONFIRM_VOID_ATTACHMENT_KEY = "confirmVoidAttachmentKey";
    private static final String EMPTY_STRING = "";
    public static final String AWARD_ATTACHMENT_PREFIX = "document.awardList[0].awardAttachments[%d]";
    private AwardNotepadBean awardNotepadBean = new AwardNotepadBean();
    private AwardCommentServiceImpl awardCommentServiceImpl = new AwardCommentServiceImpl();

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.save(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardCommentBean().setAwardCommentHistoryFlags();
        return forward;
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward actionForward = super.reload(mapping, form, request, response);
        awardForm.getAwardCommentBean().setAwardCommentScreenDisplayTypesOnForm();
        return actionForward;
    }

    public ActionForward addNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.applyRules((DocumentEvent)new AwardNoteAddEvent(EMPTY_STRING, ((AwardForm)form).getDocument(), ((AwardForm)form).getAwardNotepadBean().getNewAwardNotepad(), AwardNoteEventBase.ErrorType.HARDERROR))) {
            this.awardNotepadBean.addNote(((AwardForm)form).getAwardNotepadBean());
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateNotes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward addAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardAttachment awardAttachment = ((AwardForm)form).getAwardAttachmentFormBean().getNewAttachment();
        AwardForm awardForm = (AwardForm)form;
        AwardDocument award = awardForm.getAwardDocument();
        if (this.getKualiRuleService().applyRules((DocumentEvent)new AddAwardAttachmentEvent(EMPTY_STRING, EMPTY_STRING, award, awardAttachment))) {
            ((AwardForm)form).getAwardAttachmentFormBean().addNewAwardAttachment();
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        int selection = this.getSelectedLine(request);
        AwardAttachment attachment = awardForm.getAwardAttachmentFormBean().retrieveExistingAttachment(selection);
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), AwardNotesAndAttachmentsAction.getValidHeaderString(file.getName()), AwardNotesAndAttachmentsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int delAttachment = this.getLineToDelete(request);
        return this.confirm(this.buildDeleteAttachmentConfirmationQuestion(mapping, form, request, response, delAttachment), CONFIRM_DELETE_ATTACHMENT, EMPTY_STRING);
    }

    private StrutsConfirmation buildDeleteAttachmentConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, int deleteAttachment) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        AwardAttachment attachment = awardDocument.getAward().getAwardAttachments().get(deleteAttachment);
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_ATTACHMENT_KEY, "document.question.deleteAttachment.text", "Award Attachment", attachment.getFile().getName());
    }

    public ActionForward confirmDeleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        int delAttachment = this.getLineToDelete(request);
        awardDocument.getAward().getAwardAttachments().remove(delAttachment);
        return mapping.findForward("basic");
    }

    public ActionForward viewAwardCommentHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String awardCommentTypeCode = request.getParameter("awardCommentTypeCode");
        String awardId = request.getParameter("awardId");
        awardForm.setAwardCommentHistoryByType(this.awardCommentServiceImpl.retrieveCommentHistoryByType(awardCommentTypeCode, awardId));
        return mapping.findForward("basic");
    }

    private ActionForward redirectAwardCommentHistoryForPopup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String awardCommentTypeCode, String awardId) throws Exception {
        response.sendRedirect("awardCommentViewHistory.do?methodToCall=viewAwardCommentHistory&awardCommentTypeCode=" + awardCommentTypeCode + "&awardId=" + awardId);
        return null;
    }

    public AwardCommentServiceImpl getAwardCommentServiceImpl() {
        return this.awardCommentServiceImpl;
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        String command = request.getParameter("command");
        String awardCommentTypeCode = request.getParameter("awardCommentTypeCode");
        String awardId = request.getParameter("awardId");
        if (StringUtils.isNotBlank((CharSequence)command) && "redirectAwardCommentHistoryForPopup".equals(command)) {
            forward = this.redirectAwardCommentHistoryForPopup(mapping, form, request, response, awardCommentTypeCode, awardId);
        }
        return forward;
    }

    public ActionForward syncComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String awardCommentIndex = null;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            awardCommentIndex = StringUtils.substringBetween((String)parameterName, (String)".awardCommentIdx", (String)".");
        }
        AwardComment comment = awardForm.getAwardDocument().getAward().getAwardComment(Integer.parseInt(awardCommentIndex));
        this.getAwardSyncCreationService().addAwardSyncChange(awardForm.getAwardDocument().getAward(), new AwardSyncPendingChangeBean(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)comment, "awardComments"));
        return mapping.findForward("basic");
    }

    public ActionForward modifyAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardDocument awardDocument = ((AwardForm)form).getAwardDocument();
        awardDocument.getAwardList().get(0).getAwardAttachments().get(this.getSelectedLine(request)).setModifyAttachment(true);
        return mapping.findForward("basic");
    }

    public ActionForward voidAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildVoidAttachmentConfirmationQuestion(mapping, form, request, response), CONFIRM_VOID_ATTACHMENT, EMPTY_STRING);
    }

    public ActionForward applyModifyAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardDocument awardDocument = ((AwardForm)form).getAwardDocument();
        int selectedLineIndex = this.getSelectedLine(request);
        AwardAttachment editAwardAttachment = awardDocument.getAward().getAwardAttachments().get(selectedLineIndex);
        if (new AwardDocumentRule().processApplyModifiedAttachmentRule(new AddAwardAttachmentEvent(EMPTY_STRING, String.format(AWARD_ATTACHMENT_PREFIX, selectedLineIndex), awardDocument, editAwardAttachment))) {
            editAwardAttachment.setModifyAttachment(false);
            this.updateTimestampIfModified(editAwardAttachment);
            this.getBusinessObjectService().save((PersistableBusinessObject)editAwardAttachment);
        }
        return mapping.findForward("basic");
    }

    protected void updateTimestampIfModified(AwardAttachment editAwardAttachment) {
        if (this.hasAwardAttachmentBeenModified(editAwardAttachment)) {
            editAwardAttachment.setLastUpdateTimestamp(new Timestamp(new Date().getTime()));
            editAwardAttachment.setLastUpdateUser(this.getGlobalVariableService().getUserSession().getPrincipalName());
        }
    }

    private boolean hasAwardAttachmentBeenModified(AwardAttachment awardAttachment) {
        AwardAttachment dbAwardAttachment = (AwardAttachment)this.getBusinessObjectService().findBySinglePrimaryKey(AwardAttachment.class, (Object)awardAttachment.getAwardAttachmentId());
        return !dbAwardAttachment.getTypeCode().equals(awardAttachment.getTypeCode()) || !dbAwardAttachment.getDescription().equals(awardAttachment.getDescription());
    }

    private StrutsConfirmation buildVoidAttachmentConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_VOID_ATTACHMENT_KEY, "document.question.voidAttachment.text", EMPTY_STRING, EMPTY_STRING);
    }

    public ActionForward confirmVoidAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardDocument awardDocument = ((AwardForm)form).getAwardDocument();
        int selectedLineIndex = this.getSelectedLine(request);
        awardDocument.getAward().getAwardAttachments().get(selectedLineIndex).setDocumentStatusCode(AttachmentDocumentStatus.VOID.getCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)awardDocument.getAward().getAwardAttachments().get(selectedLineIndex));
        return mapping.findForward("basic");
    }

    public ActionForward downloadAllAwardAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDoc = awardForm.getAwardDocument();
        List<AwardAttachment> attachments = awardDoc.getAward().getAwardAttachments();
        ArrayList<AttachmentDataSource> genericAtts = new ArrayList<AttachmentDataSource>();
        for (AwardAttachment attachment : attachments) {
            AttachmentFile attachmentfile = attachment.getFile();
            PrintableAttachment newADS = new PrintableAttachment();
            newADS.setData(attachmentfile.getData());
            newADS.setType(attachmentfile.getType());
            newADS.setName(attachmentfile.getName());
            genericAtts.add(newADS);
        }
        AwardNotesAndAttachmentsAction.downloadAllAttachments(genericAtts, response, awardDoc.getAward().getAwardNumber() + "-Award_Attachments.zip");
        return RESPONSE_ALREADY_HANDLED;
    }

    protected GlobalVariableService getGlobalVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }
}

