/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.awardpayment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebParam;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardMethodOfPayment;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.award.service.AwardPaymentAndInvoicesService;
import org.kuali.kra.external.awardpayment.AwardBasisOfPaymentDTO;
import org.kuali.kra.external.awardpayment.AwardMethodOfPaymentDTO;
import org.kuali.kra.external.awardpayment.AwardPaymentWebService;
import org.kuali.kra.external.service.KcDtoService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardPaymentWebServiceImpl
implements AwardPaymentWebService {
    private BusinessObjectService businessObjectService;
    private AwardPaymentAndInvoicesService awardPaymentAndInvoicesService;
    private KcDtoService<AwardBasisOfPaymentDTO, AwardBasisOfPayment> awardBasisOfPaymentDtoService;
    private KcDtoService<AwardMethodOfPaymentDTO, AwardMethodOfPayment> awardMethodOfPaymentDtoService;

    @Override
    public AwardBasisOfPaymentDTO getBasisOfPayment(@WebParam(name="basisOfPaymentCode") String basisOfPaymentCode) {
        return this.awardBasisOfPaymentDtoService.buildDto((AwardBasisOfPayment)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBasisOfPayment.class, (Object)basisOfPaymentCode));
    }

    @Override
    public AwardMethodOfPaymentDTO getMethodOfPayment(@WebParam(name="methodOfPaymentCode") String methodOfPaymentCode) {
        return this.awardMethodOfPaymentDtoService.buildDto((AwardMethodOfPayment)this.getBusinessObjectService().findBySinglePrimaryKey(AwardMethodOfPayment.class, (Object)methodOfPaymentCode));
    }

    @Override
    public List<AwardBasisOfPaymentDTO> getMatchingBasisOfPayments(@WebParam(name="searchCriteria") AwardBasisOfPaymentDTO searchCriteria) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (searchCriteria.getBasisOfPaymentCode() != null) {
            values.put("basisOfPaymentCode", searchCriteria.getBasisOfPaymentCode());
        }
        if (searchCriteria.getDescription() != null) {
            values.put("description", searchCriteria.getDescription());
        }
        Collection basisList = null;
        basisList = values.isEmpty() ? this.getBusinessObjectService().findAll(AwardBasisOfPayment.class) : this.getBusinessObjectService().findMatching(AwardBasisOfPayment.class, values);
        return this.getBasisOfPaymentDTOs(basisList);
    }

    @Override
    public List<AwardMethodOfPaymentDTO> getMatchingMethodOfPayments(@WebParam(name="searchCriteria") AwardMethodOfPaymentDTO searchCriteria) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (searchCriteria.getMethodOfPaymentCode() != null) {
            values.put("basisOfPaymentCode", searchCriteria.getMethodOfPaymentCode());
        }
        if (searchCriteria.getDescription() != null) {
            values.put("description", searchCriteria.getDescription());
        }
        Collection basisList = null;
        basisList = values.isEmpty() ? this.getBusinessObjectService().findAll(AwardMethodOfPayment.class) : this.getBusinessObjectService().findMatching(AwardMethodOfPayment.class, values);
        return this.getMethodOfPaymentDTOs(basisList);
    }

    @Override
    public List<AwardMethodOfPaymentDTO> getMatchingMethodOfPaymentsForBasisOfPayment(@WebParam(name="basisOfPaymentCode") String basisOfPaymentCode) {
        List<ValidBasisMethodPayment> validPayments = this.getAwardPaymentAndInvoicesService().getValidBasisMethodPaymentByBasisCode(basisOfPaymentCode);
        ArrayList<AwardMethodOfPaymentDTO> result = new ArrayList<AwardMethodOfPaymentDTO>();
        if (validPayments != null) {
            for (ValidBasisMethodPayment validPayment : validPayments) {
                result.add(this.awardMethodOfPaymentDtoService.buildDto(validPayment.getMethodOfPayment()));
            }
        }
        return result;
    }

    protected List<AwardBasisOfPaymentDTO> getBasisOfPaymentDTOs(Collection<AwardBasisOfPayment> basisList) {
        ArrayList<AwardBasisOfPaymentDTO> result = new ArrayList<AwardBasisOfPaymentDTO>();
        if (basisList != null) {
            for (AwardBasisOfPayment basis : basisList) {
                result.add(this.awardBasisOfPaymentDtoService.buildDto(basis));
            }
        }
        return result;
    }

    protected List<AwardMethodOfPaymentDTO> getMethodOfPaymentDTOs(Collection<AwardMethodOfPayment> basisList) {
        ArrayList<AwardMethodOfPaymentDTO> result = new ArrayList<AwardMethodOfPaymentDTO>();
        if (basisList != null) {
            for (AwardMethodOfPayment basis : basisList) {
                result.add(this.awardMethodOfPaymentDtoService.buildDto(basis));
            }
        }
        return result;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected AwardPaymentAndInvoicesService getAwardPaymentAndInvoicesService() {
        return this.awardPaymentAndInvoicesService;
    }

    public void setAwardPaymentAndInvoicesService(AwardPaymentAndInvoicesService awardPaymentAndInvoicesService) {
        this.awardPaymentAndInvoicesService = awardPaymentAndInvoicesService;
    }

    public KcDtoService<AwardBasisOfPaymentDTO, AwardBasisOfPayment> getAwardBasisOfPaymentDtoService() {
        return this.awardBasisOfPaymentDtoService;
    }

    public void setAwardBasisOfPaymentDtoService(KcDtoService<AwardBasisOfPaymentDTO, AwardBasisOfPayment> awardBasisOfPaymentDtoService) {
        this.awardBasisOfPaymentDtoService = awardBasisOfPaymentDtoService;
    }

    public KcDtoService<AwardMethodOfPaymentDTO, AwardMethodOfPayment> getAwardMethodOfPaymentDtoService() {
        return this.awardMethodOfPaymentDtoService;
    }

    public void setAwardMethodOfPaymentDtoService(KcDtoService<AwardMethodOfPaymentDTO, AwardMethodOfPayment> awardMethodOfPaymentDtoService) {
        this.awardMethodOfPaymentDtoService = awardMethodOfPaymentDtoService;
    }
}

