/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web.struts.action;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentFormBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.institutionalproposal.attachments.InstitutionalProposalAttachmentFormBean;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalLockService;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.DocumentPresentationController;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalAction
extends KcTransactionalDocumentActionBase {
    private static final String MODIFY_IP = "modifyIP";
    private static final String DISABLE_ATTACHMENT_REMOVAL = "disableAttachmentRemoval";
    private ProjectPublisher projectPublisher;
    private ProjectRetrievalService projectRetrievalService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        if (GlobalVariables.getAuditErrorMap().isEmpty()) {
            KcServiceLocator.getService(AuditHelper.class).auditConditionally((InstitutionalProposalForm)form);
        }
        if (institutionalProposalForm.isAuditActivated()) {
            institutionalProposalForm.setUnitRulesMessages(this.getUnitRulesMessages(institutionalProposalForm.getInstitutionalProposalDocument()));
        }
        return actionForward;
    }

    @Override
    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        if (formBase.isFormDocumentInitialized()) {
            Document document = formBase.getDocument();
            Person user = GlobalVariables.getUserSession().getPerson();
            DocumentPresentationController documentPresentationController = KNSServiceLocator.getDocumentHelperService().getDocumentPresentationController(document);
            DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
            Set documentActions = documentPresentationController.getDocumentActions(document);
            documentActions = documentAuthorizer.getDocumentActions(document, user, documentActions);
            if (this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking()) {
                documentActions = this.getPessimisticLockService().getDocumentActions(document, user, documentActions);
            }
            HashSet<String> editModes = new HashSet<String>();
            if (!documentAuthorizer.canOpen(document, user)) {
                editModes.add("unviewable");
            } else if (documentActions.contains("canEdit") && !((KcTransactionalDocumentFormBase)formBase).isViewOnly()) {
                editModes.add("fullEntry");
            } else {
                editModes.add("viewOnly");
            }
            if (this.hasPermission("Edit Institutional Proposal")) {
                editModes.add(MODIFY_IP);
            }
            Map editMode = this.convertSetToMap(editModes);
            if (this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking()) {
                editMode = this.getPessimisticLockService().establishLocks(document, editMode, user);
            }
            if (editMode.containsKey("fullEntry")) {
                if (!documentActions.contains("canEditDocumentOverview")) {
                    documentActions.add("canEditDocumentOverview");
                }
            } else {
                if (documentActions.contains("canEditDocumentOverview")) {
                    documentActions.remove("canEditDocumentOverview");
                }
                if (documentActions.contains("canSave")) {
                    documentActions.remove("canSave");
                }
            }
            if (editMode.containsKey("viewOnly") && !editMode.containsKey(MODIFY_IP) && documentActions.contains("canReload")) {
                documentActions.remove("canReload");
            }
            formBase.setDocumentActions(this.convertSetToMap(documentActions));
            formBase.setEditingMode(editMode);
        }
    }

    private boolean hasPermission(String permissionName) {
        KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.getUserName());
        return this.getUnitAuthorizationService().hasPermission(person.getPersonId(), "KC-IP", permissionName);
    }

    private String getUserName() {
        return GlobalVariables.getUserSession().getPerson().getPrincipalName();
    }

    private UnitAuthorizationService getUnitAuthorizationService() {
        return KcServiceLocator.getService(UnitAuthorizationService.class);
    }

    private KcPersonService getKcPersonService() {
        return KcServiceLocator.getService(KcPersonService.class);
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Project project;
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        ActionForward forward = super.save(mapping, form, request, response);
        if (institutionalProposalForm.getMethodToCall().equals("save") && institutionalProposalForm.isAuditActivated()) {
            forward = mapping.findForward("institutionalProposalActions");
        }
        if ((project = this.getProjectRetrievalService().retrieveProject(institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().getProposalNumber())) != null) {
            this.getProjectPublisher().publishProject(project);
        }
        return forward;
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        if (institutionalProposalForm.getViewFundingSource()) {
            return mapping.findForward("closePage");
        }
        return super.close(mapping, form, request, response);
    }

    public ActionForward home(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("home");
    }

    public ActionForward contacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        ipForm.getCentralAdminContactsBean().initCentralAdminContacts();
        return mapping.findForward("contacts");
    }

    public ActionForward Contacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.contacts(mapping, form, request, response);
    }

    public ActionForward specialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((InstitutionalProposalForm)form).getSpecialReviewHelper().prepareView();
        return mapping.findForward("specialReview");
    }

    public ActionForward intellectualPropertyReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("intellectualPropertyReview");
    }

    public ActionForward distribution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("distribution");
    }

    public ActionForward attachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setDisableAttachmentRemovalIndicator(((InstitutionalProposalForm)form).getInstitutionalProposalAttachmentBean());
        return mapping.findForward("attachments");
    }

    private void setDisableAttachmentRemovalIndicator(InstitutionalProposalAttachmentFormBean institutionalProposalAttachmentFormBean) {
        if (institutionalProposalAttachmentFormBean != null) {
            institutionalProposalAttachmentFormBean.setDisableAttachmentRemovalIndicator(this.getParameterService().getParameterValueAsBoolean("KC-GEN", "Document", DISABLE_ATTACHMENT_REMOVAL));
        }
    }

    public ActionForward institutionalProposalActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String command = request.getParameter("command");
        if (StringUtils.isNotEmpty((CharSequence)command) && "displayDocSearchView".equals(command)) {
            this.loadDocumentInForm(request, (InstitutionalProposalForm)form);
        }
        return mapping.findForward("institutionalProposalActions");
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        institutionalProposalForm.getCustomDataHelper().prepareCustomData();
        return mapping.findForward("customData");
    }

    ActionForward handleDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, InstitutionalProposalForm institutionalProposalForm) throws Exception {
        return super.docHandler(mapping, form, request, response);
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        String command = institutionalProposalForm.getCommand();
        if ("institutionalProposalActions".equals(command)) {
            this.loadDocument((KualiDocumentFormBase)institutionalProposalForm);
            forward = this.institutionalProposalActions(mapping, form, request, response);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        if (request.getParameter("docOpenedFromIPSearch") != null && request.getParameter("docOpenedFromIPSearch").equals("true")) {
            institutionalProposalForm.setDocOpenedFromIPSearch(true);
        }
        if ("institutionalProposalActions".equals(command)) {
            forward = this.institutionalProposalActions(mapping, form, request, response);
        }
        return forward;
    }

    @Override
    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        InstitutionalProposal proposal = ((InstitutionalProposalForm)kualiDocumentFormBase).getInstitutionalProposalDocument().getInstitutionalProposal();
        proposal.setSponsorNihMultiplePi(this.getSponsorHierarchyService().isSponsorNihMultiplePi(proposal.getSponsorCode()));
        if (!proposal.getProjectPersons().isEmpty()) {
            proposal.getProjectPersons().get(0);
        }
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        if (institutionalProposalForm.getDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, institutionalProposalForm);
        }
        InstitutionalProposalDocument document = (InstitutionalProposalDocument)institutionalProposalForm.getDocument();
        institutionalProposalForm.getMedusaBean().setMedusaViewRadio("0");
        institutionalProposalForm.getMedusaBean().setModuleName("IP");
        institutionalProposalForm.getMedusaBean().setModuleIdentifier(document.getInstitutionalProposal().getProposalId());
        institutionalProposalForm.getMedusaBean().generateParentNodes();
        return mapping.findForward("medusa");
    }

    protected void loadDocumentInForm(HttpServletRequest request, InstitutionalProposalForm institutionalProposalForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        InstitutionalProposalDocument retrievedDocument = (InstitutionalProposalDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        institutionalProposalForm.setDocument((Document)retrievedDocument);
        request.setAttribute("docId", (Object)docIdRequestParameter);
    }

    protected final boolean applyRules(DocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    protected PessimisticLockService getPessimisticLockService() {
        return KcServiceLocator.getService(InstitutionalProposalLockService.class);
    }

    protected SponsorHierarchyService getSponsorHierarchyService() {
        return KcServiceLocator.getService(SponsorHierarchyService.class);
    }

    protected List<String> getUnitRulesMessages(InstitutionalProposalDocument ipDoc) {
        KrmsRulesExecutionService rulesService = KcServiceLocator.getService(KrmsRulesExecutionService.class);
        return rulesService.processUnitValidations(ipDoc.getLeadUnitNumber(), ipDoc);
    }

    public ProjectPublisher getProjectPublisher() {
        if (this.projectPublisher == null) {
            this.projectPublisher = KcServiceLocator.getService(ProjectPublisher.class);
        }
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public ProjectRetrievalService getProjectRetrievalService() {
        if (this.projectRetrievalService == null) {
            this.projectRetrievalService = (ProjectRetrievalService)KcServiceLocator.getService("instPropProjectRetrievalService");
        }
        return this.projectRetrievalService;
    }

    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }
}

