/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.auth.ProtocolAuthorizerBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ProtocolAuthorizer
extends ProtocolAuthorizerBase {
    private static final String NAMESPACE = "KC-UNT";

    @Override
    public final boolean isAuthorized(String userId, ProtocolTaskBase task) {
        return this.isAuthorized(userId, (ProtocolTask)task);
    }

    public abstract boolean isAuthorized(String var1, ProtocolTask var2);

    protected final boolean hasCommitteeId(Protocol protocol) {
        return protocol.getProtocolSubmission().getCommitteeId() != null;
    }

    public boolean isIrbAdmin(String userId) {
        return this.systemAuthorizationService.hasRole(userId, NAMESPACE, "IRB Administrator");
    }

    protected ProtocolSubmission findSubmission(Protocol protocol) {
        return this.findSubmission(protocol, false);
    }

    protected ProtocolSubmission findSubmissionIncludingInAgenda(Protocol protocol) {
        return this.findSubmission(protocol, true);
    }

    private ProtocolSubmission findSubmission(Protocol protocol, boolean includeInAgenda) {
        ProtocolSubmission protocolSubmission = null;
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"102") && !StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"100") && (!includeInAgenda || !StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"101"))) continue;
            protocolSubmission = (ProtocolSubmission)submission;
        }
        return protocolSubmission;
    }

    protected boolean isRequestForSuspension(Protocol protocol) {
        ProtocolSubmission submission = this.findSubmission(protocol);
        return submission != null && "110".equals(submission.getSubmissionTypeCode());
    }

    protected boolean canPerformActionOnExpeditedOrExempt(ProtocolSubmission lastSubmission, ProtocolAction lastAction) {
        boolean canPerform = false;
        if (this.isSubmissionValidForAction(lastSubmission)) {
            canPerform = this.isExpeditedOrExempt(lastSubmission.getProtocolReviewType().getReviewTypeCode()) && "101".equals(lastAction.getProtocolActionTypeCode());
        }
        return canPerform;
    }

    protected boolean canPerformActionOnExpedited(Protocol protocol) {
        ProtocolSubmission submission = this.findSubmission(protocol);
        boolean canPerform = false;
        if (this.isSubmissionValidForAction(submission)) {
            canPerform = this.isExpeditedSubmission(submission);
        }
        return canPerform;
    }

    private boolean isSubmissionValidForAction(ProtocolSubmission submission) {
        return ObjectUtils.isNotNull((Object)submission.getCommitteeId()) && ObjectUtils.isNotNull((Object)submission.getScheduleId());
    }

    private boolean isExpeditedOrExempt(String reviewTypeCode) {
        return this.isExpedited(reviewTypeCode) || this.isExempt(reviewTypeCode);
    }

    private boolean isExpedited(String reviewTypeCode) {
        return "2".equals(reviewTypeCode);
    }

    private boolean isExempt(String reviewTypeCode) {
        return "3".equals(reviewTypeCode);
    }

    private boolean isExpeditedSubmission(ProtocolSubmission submission) {
        return submission != null && this.isExpedited(submission.getProtocolReviewTypeCode());
    }
}

