/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.auth;

import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizerBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolAuthorizerBase
extends TaskAuthorizerBase {
    protected KcAuthorizationService kraAuthorizationService;
    protected SystemAuthorizationService systemAuthorizationService;
    private ProtocolActionService protocolActionService;

    public final void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    @Override
    public final boolean isAuthorized(String userId, Task task) {
        return this.isAuthorized(userId, (ProtocolTaskBase)task);
    }

    public abstract boolean isAuthorized(String var1, ProtocolTaskBase var2);

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected final boolean hasPermission(String userId, ProtocolBase protocol, String permissionName) {
        return this.kraAuthorizationService.hasPermission(userId, protocol, permissionName);
    }

    protected final boolean isAmendmentOrRenewal(ProtocolBase protocol) {
        return protocol.getProtocolNumber() != null && (protocol.getProtocolNumber().contains(ProtocolSpecialVersion.AMENDMENT.getCode()) || protocol.getProtocolNumber().contains(ProtocolSpecialVersion.RENEWAL.getCode()) || protocol.getProtocolNumber().contains(ProtocolSpecialVersion.CONTINUATION.getCode()) || protocol.getProtocolNumber().contains(ProtocolSpecialVersion.FYI.getCode()));
    }

    protected final boolean canExecuteAction(ProtocolBase protocol, String protocolActionTypeCode) {
        return protocol.isActive() && !protocol.getProtocolDocument().isViewOnly() && this.protocolActionService.isActionAllowed(protocolActionTypeCode, protocol);
    }

    protected boolean isPessimisticLocked(Document document) {
        boolean isLocked = false;
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(GlobalVariables.getUserSession().getPerson())) continue;
            isLocked = true;
        }
        return isLocked;
    }

    protected boolean isAdmin(String userId, String namespace, String role) {
        return this.systemAuthorizationService.hasRole(userId, namespace, role);
    }

    protected boolean isRequestForSuspension(ProtocolSubmissionBase submission, String submissionType) {
        return submission != null && submissionType.equals(submission.getSubmissionTypeCode());
    }

    public SystemAuthorizationService getSystemAuthorizationService() {
        return this.systemAuthorizationService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }
}

