/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.protocol.ProtocolNumberServiceBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProposalDevelopmentProtocolDocumentServiceImplBase<T extends ProtocolDocumentBase> {
    private SystemAuthorizationService systemAuthorizationService;
    private KcAuthorizationService kraAuthorizationService;
    private KcPersonService kcPersonService;
    private SequenceAccessorService sequenceAccessorService;
    private UnitAuthorizationService unitAuthorizationService;
    private DocumentService documentService;

    public T createProtocolDocument(ProposalDevelopmentDocument document) throws Exception {
        ProtocolDocumentBase protocolDocument = null;
        DevelopmentProposal developmentProposal = document.getDevelopmentProposal();
        if (this.isAuthorizedCreateProtocol(document)) {
            DocumentService documentService = this.getDocumentService();
            protocolDocument = this.getProtocolDocumentNewInstanceHook(documentService);
            this.populateDocumentOverview(developmentProposal, protocolDocument);
            this.populateRequiredFields(developmentProposal, protocolDocument);
            this.populateProtocolPerson_Investigator(developmentProposal, protocolDocument);
            this.populateProtocolFundingSource(developmentProposal, protocolDocument);
            try {
                documentService.saveDocument((Document)protocolDocument);
            }
            catch (ValidationException e) {
                return null;
            }
            this.initializeAuthorization(protocolDocument);
        }
        return (T)protocolDocument;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    protected void populateDocumentOverview(DevelopmentProposal developmentProposal, ProtocolDocumentBase protocolDocument) {
        ProposalDevelopmentDocument proposalDocument = developmentProposal.getProposalDocument();
        DocumentHeader proposalDocumentHeader = proposalDocument.getDocumentHeader();
        DocumentHeader protocolDocumentHeader = protocolDocument.getDocumentHeader();
        protocolDocumentHeader.setDocumentDescription(this.getProtocolNameSpaceHook() + " " + proposalDocumentHeader.getDocumentDescription());
        protocolDocumentHeader.setExplanation("Document created from Proposal - " + proposalDocumentHeader.getDocumentNumber());
        protocolDocumentHeader.setOrganizationDocumentNumber(proposalDocumentHeader.getOrganizationDocumentNumber());
    }

    protected void populateRequiredFields(DevelopmentProposal developmentProposal, ProtocolDocumentBase protocolDocument) throws Exception {
        ProtocolBase protocol = protocolDocument.getProtocol();
        protocol.setProtocolNumber(this.getProtocolNumberServiceHook().generateProtocolNumber());
        protocol.setSequenceNumber(0);
        Long nextProtocolId = this.sequenceAccessorService.getNextAvailableSequenceNumber(this.getSequenceNumberNameHook(), protocol.getClass());
        protocol.setProtocolId(nextProtocolId);
        protocol.setTitle(developmentProposal.getTitle());
        protocol.setLeadUnitNumber(developmentProposal.getOwnedByUnitNumber());
        protocol.setPrincipalInvestigatorId(developmentProposal.getPrincipalInvestigator().getPersonId());
        protocol.setProtocolTypeCode(this.getProtocolTypeCodeHook());
        this.populateProtocolSpecificFieldsHook(protocol);
        ProtocolActionBase protocolAction = this.getProtocolActionNewInstanceHook(protocolDocument.getProtocol(), null, this.getProtocolActionProtocolCreatedCodeHook());
        protocolAction.setComments(this.getProtocolCreatedHook());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
    }

    protected void initializeAuthorization(ProtocolDocumentBase protocolDocument) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        this.kraAuthorizationService.addDocumentLevelRole(userId, this.getProtocolAggregatorHook(), protocolDocument.getProtocol());
        this.kraAuthorizationService.addDocumentLevelRole(userId, this.getProtocolApproverHook(), protocolDocument.getProtocol());
        List<Role> roles = this.systemAuthorizationService.getRoles(this.getProtocolRoleTypeHook());
        for (Role role : roles) {
            List<String> users = this.kraAuthorizationService.getPrincipalsInRole(role.getName(), protocolDocument.getProtocol());
            ArrayList<KcPerson> persons = new ArrayList<KcPerson>();
            for (String uid : users) {
                KcPerson person = this.kcPersonService.getKcPersonByPersonId(uid);
                if (person == null || !person.getActive().booleanValue()) continue;
                persons.add(person);
            }
            for (KcPerson person : persons) {
                if (StringUtils.equals((CharSequence)person.getPersonId(), (CharSequence)userId)) continue;
                this.kraAuthorizationService.addDocumentLevelRole(person.getPersonId(), role.getName(), protocolDocument.getProtocol());
            }
        }
    }

    protected void populateProtocolPerson_Investigator(DevelopmentProposal developmentProposal, ProtocolDocumentBase protocolDocument) {
        ProtocolPersonBase protocolPerson = this.getProtocolPersonNewInstanceHook();
        ProtocolBase protocol = protocolDocument.getProtocol();
        protocolPerson.setPersonId(protocol.getPrincipalInvestigatorId());
        protocolPerson.setPersonName(developmentProposal.getPrincipalInvestigatorName());
        protocolPerson.setProtocolPersonRoleId("PI");
        ProtocolPersonnelService protocolPersonnelService = this.getProtocolPersonnelService();
        protocolPersonnelService.addProtocolPerson(protocol, protocolPerson);
    }

    public boolean isAuthorizedCreateProtocol(ProposalDevelopmentDocument document) {
        return this.hasProposalRequiredFields(document.getDevelopmentProposal()) && this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), this.getCreateProposalPermissionNamespaceHook(), this.getCreateProposalPermissionNameHook());
    }

    protected boolean hasProposalRequiredFields(DevelopmentProposal proposal) {
        ProposalPerson person;
        boolean validProposalRequiredFields = true;
        if (StringUtils.isEmpty((CharSequence)proposal.getTitle())) {
            validProposalRequiredFields = false;
        }
        if (StringUtils.isEmpty((CharSequence)proposal.getOwnedByUnitNumber())) {
            validProposalRequiredFields = false;
        }
        if ((person = proposal.getPrincipalInvestigator()) == null || StringUtils.isEmpty((CharSequence)person.getPersonId())) {
            validProposalRequiredFields = false;
        }
        return validProposalRequiredFields;
    }

    protected abstract String getCreateProposalPermissionNameHook();

    protected abstract String getCreateProposalPermissionNamespaceHook();

    private ProtocolFundingSourceService getProtocolFundingSourceService() {
        return this.getProtocolFundingSourceServiceHook();
    }

    protected void populateProtocolFundingSource(DevelopmentProposal developmentProposal, ProtocolDocumentBase protocolDocument) {
        ProtocolBase protocol = protocolDocument.getProtocol();
        List<ProtocolFundingSourceBase> protocolFundingSources = protocol.getProtocolFundingSources();
        ProtocolFundingSourceService protocolFundingSourceService = this.getProtocolFundingSourceService();
        ProtocolFundingSourceBase protocolFundingSource = protocolFundingSourceService.updateProtocolFundingSource("1", developmentProposal.getSponsorCode(), developmentProposal.getSponsorName());
        protocolFundingSource.setProtocol(protocolDocument.getProtocol());
        protocolFundingSources.add(protocolFundingSource);
    }

    protected ProtocolPersonnelService getProtocolPersonnelService() {
        return this.getProtocolPersonnelServiceHook();
    }

    protected abstract ProtocolDocumentBase getProtocolDocumentNewInstanceHook(DocumentService var1) throws WorkflowException;

    protected abstract String getProtocolActionProtocolCreatedCodeHook();

    protected abstract String getProtocolTypeCodeHook();

    protected abstract void populateProtocolSpecificFieldsHook(ProtocolBase var1);

    protected abstract ProtocolNumberServiceBase getProtocolNumberServiceHook();

    protected abstract ProtocolActionBase getProtocolActionNewInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2, String var3);

    protected abstract String getProtocolAggregatorHook();

    protected abstract String getProtocolApproverHook();

    protected abstract String getProtocolRoleTypeHook();

    protected abstract String getProtocolNameSpaceHook();

    protected abstract String getSequenceNumberNameHook();

    protected abstract ProtocolPersonBase getProtocolPersonNewInstanceHook();

    protected abstract String getProtocolCreatedHook();

    protected abstract ProtocolPersonnelService getProtocolPersonnelServiceHook();

    protected abstract ProtocolFundingSourceService getProtocolFundingSourceServiceHook();

    public UnitAuthorizationService getUnitAuthorizationService() {
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

