/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;

public class IacucProtocolFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private DocumentService documentService;

    @Override
    public void addFacts(Facts.Builder factsBuilder, String docContent) {
        String documentNumber = this.getElementValue(docContent, "//documentNumber");
        try {
            IacucProtocolDocument protocolDocument = (IacucProtocolDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.addFacts(factsBuilder, protocolDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder, KrmsRulesContext document) {
        IacucProtocolDocument protocolDocument = (IacucProtocolDocument)document;
        IacucProtocol protocol = protocolDocument.getIacucProtocol();
        this.addObjectMembersAsFacts(factsBuilder, protocol, "KC-IACUC-CONTEXT", "KC-IACUC");
        factsBuilder.addFact("IacucProtocol", (Object)protocol);
        factsBuilder.addFact("moduleCode", (Object)"9");
        factsBuilder.addFact("moduleItemKey", (Object)protocol.getProtocolNumber());
        factsBuilder.addFact("moduleSubItemKey", (Object)protocol.getSequenceNumber());
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

