/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.mq.rest;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.coeus.sys.framework.mq.rest.RestRequest;
import org.kuali.coeus.sys.impl.mq.rest.RestDestinationRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.UnknownHttpStatusCodeException;

@Component(value="restMessageConsumer")
public class RestMessageConsumer
implements MessageListener {
    private static Logger LOG = LogManager.getLogger(RestMessageConsumer.class);
    @Autowired
    @Qualifier(value="restDestinationRegistry")
    private RestDestinationRegistry restDestinationRegistry;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations consumerRestOperations;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;

    public void onMessage(Message message) {
        String url;
        RestRequest request;
        try {
            request = (RestRequest)((ObjectMessage)message).getObject();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Consuming Message " + request);
        }
        if (StringUtils.isBlank((CharSequence)(url = this.retrieveUrl(request)))) {
            throw new IllegalStateException("url not found for destination " + request.getDestination());
        }
        Map<String, List<String>> params = request.getParams() != null ? request.getParams() : Collections.emptyMap();
        HttpHeaders headers = new HttpHeaders();
        if (request.getHeaders() != null) {
            headers.putAll(request.getHeaders());
        }
        headers.put("Authorization", Collections.singletonList("Bearer " + this.getJwtService().createToken()));
        HttpEntity entity = StringUtils.isNotBlank((CharSequence)request.getBody()) ? new HttpEntity((Object)request.getBody(), (MultiValueMap)headers) : HttpEntity.EMPTY;
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().name());
        this.makeCall(url, params, entity, method);
    }

    public String retrieveUrl(RestRequest request) {
        return this.restDestinationRegistry.findUrl(request.getDestination());
    }

    protected void makeCall(String url, Map<String, List<String>> params, HttpEntity<?> entity, HttpMethod method) {
        try {
            ResponseEntity response = this.consumerRestOperations.exchange(url, method, entity, Void.class, params);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.createSentMsg(url, params, entity, method) + " status code " + response.getStatusCode());
            }
        }
        catch (UnknownHttpStatusCodeException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(this.createSentMsg(url, params, entity, method) + " status code " + e.getRawStatusCode());
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(this.createSentMsg(url, params, entity, method) + " in error " + e.getMessage());
            }
            throw e;
        }
    }

    protected String createSentMsg(String url, Map<String, List<String>> params, HttpEntity<?> entity, HttpMethod method) {
        return "REST request sent for url: " + url + " method " + method + " body " + entity + " parameters " + params;
    }

    public RestDestinationRegistry getRestDestinationRegistry() {
        return this.restDestinationRegistry;
    }

    public void setRestDestinationRegistry(RestDestinationRegistry restDestinationRegistry) {
        this.restDestinationRegistry = restDestinationRegistry;
    }

    public RestOperations getConsumerRestOperations() {
        return this.consumerRestOperations;
    }

    public void setConsumerRestOperations(RestOperations consumerRestOperations) {
        this.consumerRestOperations = consumerRestOperations;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }
}

