/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

public class AwardCfdaAuditRule
implements DocumentAuditRule {
    public static final String HOME_PAGE_AUDIT_WARNINGS = "homePageAuditWarnings";
    private GlobalVariableService globalVariableService;

    public boolean processRunAuditBusinessRules(Document document) {
        AwardDocument awardDocument = (AwardDocument)document;
        for (int i = 0; i < awardDocument.getAward().getAwardCfdas().size(); ++i) {
            String cfdaNumber = awardDocument.getAward().getAwardCfdas().get(i).getCfdaNumber();
            if (this.isValidCfda(cfdaNumber)) continue;
            this.getAuditWarnings(HOME_PAGE_AUDIT_WARNINGS, "Warnings").add(new AuditError(String.format("document.awardList[0].awardCfdas[%s].cfdaNumber", i), "error.format.cfda", "home.anchorDetailsDates", new String[]{cfdaNumber}));
        }
        return true;
    }

    public boolean isValidCfda(String cfdaNumber) {
        return StringUtils.isBlank((CharSequence)cfdaNumber) || cfdaNumber.matches("(\\d{2})(\\.)(\\d{3})[a-zA-z]?");
    }

    protected List<AuditError> getAuditWarnings(String key, String severity) {
        if (!this.getGlobalVariableService().getAuditErrorMap().containsKey(key)) {
            this.getGlobalVariableService().getAuditErrorMap().put(key, new AuditCluster("Details & Dates", new ArrayList(), severity));
        }
        return this.getGlobalVariableService().getAuditErrorMap().get(key).getAuditErrorList();
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }
}

