/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetService;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.krad.service.DocumentService;

public class AwardBudgetsAction
extends AwardAction
implements AuditModeAction {
    private static final Logger LOG = LogManager.getLogger(AwardBudgetsAction.class);
    private static final String CONFIRM_SYNCH_BUDGET_RATE = "confirmSynchBudgetRate";
    private static final String NO_SYNCH_BUDGET_RATE = "noSynchBudgetRate";
    public static final String DEFAULT_BUDGET_ACTIVITY_TYPE_CODE = "x";
    private static final String SHOW_ALL_BUDGET_VERSIONS_URL_PARAM = "showAllBudgetVersions=";
    private static final String AUDIT_ACTIVATED_URL_PARAM = "auditActivated=";
    private static final String AMPERSTAND = "&";
    public static final String SYNC_QUESTION_ASKED = "syncQuestionAsked";
    private DocumentService documentService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (!StringUtils.equals((CharSequence)awardForm.getMethodToCall(), (CharSequence)"save") && awardForm.isSaveAfterCopy()) {
            List<AwardBudgetExt> overviews = awardForm.getAwardDocument().getBudgetDocumentVersions();
            AwardBudgetExt copiedBudget = overviews.get(overviews.size() - 1);
            String copiedName = copiedBudget.getName();
            copiedBudget.setName("copied placeholder");
            LOG.debug("validating " + copiedName);
            boolean valid = this.getBudgetService().isBudgetVersionNameValid(awardForm.getAwardDocument().getAward(), copiedName);
            copiedBudget.setName(copiedName);
            awardForm.setSaveAfterCopy(!valid);
            if (!valid) {
                return mapping.findForward("basic");
            }
            awardForm.getAwardDocument().updateBudgetDescriptions(awardForm.getAwardDocument().getAward().getBudgets());
        }
        request.setAttribute("rateClassMap", this.getBudgetRatesService().getBudgetRateClassMap("O"));
        ActionForward ac = super.execute(mapping, form, request, response);
        this.getAwardBudgetService().populateBudgetLimitSummary(awardForm.getBudgetLimitSummary(), awardForm.getAwardDocument().getAward());
        return ac;
    }

    public ActionForward addBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Budget newBudget;
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDoc = awardForm.getAwardDocument();
        ActionForward actionForward = this.activate(mapping, form, request, response);
        if (actionForward == mapping.findForward("basic") && (newBudget = this.getBudgetService().addBudgetVersion(awardDoc, awardForm.getNewBudgetVersionName(), Collections.EMPTY_MAP)) != null) {
            awardForm.setNewBudgetVersionName("");
        }
        return actionForward;
    }

    public ActionForward rebudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDoc = awardForm.getAwardDocument();
        AwardBudgetDocument newBudgetDoc = this.getAwardBudgetService().rebudget(awardDoc, awardForm.getNewBudgetVersionName());
        if (newBudgetDoc != null) {
            awardForm.setNewBudgetVersionName("");
        }
        return mapping.findForward("basic");
    }

    public ActionForward openBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        BudgetService budgetService = KcServiceLocator.getService(BudgetService.class);
        BudgetRatesService budgetRatesService = KcServiceLocator.getService(BudgetRatesService.class);
        AwardBudgetService awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
        if ("TRUE".equals(awardForm.getEditingMode().get("modifyAwardBudget"))) {
            this.save(mapping, form, request, response);
        }
        AwardDocument awardDocument = awardForm.getAwardDocument();
        awardDocument.refreshBudgetDocumentVersions();
        Budget budgetToOpen = awardDocument.getBudgetDocumentVersion(this.getSelectedLine(request));
        Collection<BudgetRate> allBudgetRates = budgetService.getSavedProposalRates(budgetToOpen);
        Award newestAward = this.getAwardBudgetService().getActiveOrNewestAward(awardDocument.getAward().getAwardNumber());
        newestAward.refreshReferenceObject("awardFandaRate");
        ArrayList<ScaleTwoDecimal> ebRates = new ArrayList<ScaleTwoDecimal>();
        if (newestAward.getSpecialEbRateOffCampus() != null) {
            ebRates.add(newestAward.getSpecialEbRateOffCampus());
        }
        if (newestAward.getSpecialEbRateOnCampus() != null) {
            ebRates.add(newestAward.getSpecialEbRateOnCampus());
        }
        if (newestAward.getRequestedStartDateInitial() == null || newestAward.getRequestedEndDateInitial() == null) {
            return mapping.findForward("basic");
        }
        if (this.awardBudgetDocumentIsNotFinal(budgetToOpen) && awardBudgetService.checkRateChange(allBudgetRates, newestAward)) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchAwardRates.text"), CONFIRM_SYNCH_BUDGET_RATE, NO_SYNCH_BUDGET_RATE);
        }
        if (budgetRatesService.checkActivityTypeChange(allBudgetRates, newestAward.getActivityTypeCode())) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchBudgetRate.text"), CONFIRM_SYNCH_BUDGET_RATE, NO_SYNCH_BUDGET_RATE);
        }
        if (CollectionUtils.isEmpty(allBudgetRates)) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.noRatesSynch.text"), CONFIRM_SYNCH_BUDGET_RATE, NO_SYNCH_BUDGET_RATE);
        }
        AwardBudgetDocument budgetDocument = (AwardBudgetDocument)this.getDocumentService().getByDocumentHeaderId(budgetToOpen.getDocumentNumber());
        String routeHeaderId = budgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        AwardBudgetExt budget = budgetDocument.getBudget();
        if (budget.getActivityTypeCode().equals(DEFAULT_BUDGET_ACTIVITY_TYPE_CODE)) {
            budget.setActivityTypeCode(this.getBudgetService().getActivityTypeForBudget(budget));
        }
        String backUrl = URLEncoder.encode(this.buildActionUrl(awardDocument.getDocumentNumber(), "budgets", "AwardDocument"), StandardCharsets.UTF_8.name());
        Object forward = this.buildForwardUrl(routeHeaderId) + "&backLocation=" + backUrl;
        forward = StringUtils.replace((String)forward, (String)"awardBudgetVersions.do?", (String)"awardBudgetParameters.do?");
        if (!budget.getActivityTypeCode().equals(newestAward.getActivityTypeCode()) || budget.isRateClassTypesReloaded()) {
            budget.setActivityTypeCode(newestAward.getActivityTypeCode());
            forward = ((String)forward).replace("awardBudgetParameters.do?", "awardBudgetParameters.do?syncBudgetRate=Y&");
        }
        forward = StringUtils.replace((String)forward, (String)"awardBudgetParameters.do?", (String)("awardBudgetParameters.do?auditActivated=" + awardForm.isAuditActivated() + AMPERSTAND));
        forward = StringUtils.replace((String)forward, (String)"awardBudgetParameters.do?", (String)("awardBudgetParameters.do?showAllBudgetVersions=" + awardForm.isShowAllBudgetVersions() + AMPERSTAND));
        return new ActionForward((String)forward, true);
    }

    private boolean awardBudgetDocumentIsNotFinal(Budget budget) throws WorkflowException {
        AwardBudgetDocument budgetDocument = (AwardBudgetDocument)this.getDocumentService().getByDocumentHeaderId(budget.getDocumentNumber());
        String documentStatusCode = budgetDocument.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return !documentStatusCode.equals("F");
    }

    public ActionForward confirmSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchBudgetRate(mapping, form, request, response, true);
    }

    public ActionForward noSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchBudgetRate(mapping, form, request, response, false);
    }

    private ActionForward synchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean confirm) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDoc = awardForm.getAwardDocument();
        Budget budgetToOpen = awardDoc.getBudgetDocumentVersion(this.getSelectedLine(request));
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)this.getDocumentService().getByDocumentHeaderId(budgetToOpen.getDocumentNumber());
        String routeHeaderId = awardBudgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        String forward = this.buildForwardUrl(routeHeaderId);
        if (confirm) {
            awardBudgetDocument.getBudget().setActivityTypeCode(awardDoc.getBudgetParent().getActivityTypeCode());
            AwardBudgetExt budget = awardBudgetDocument.getBudget();
            budget.setRateClassTypesReloaded(false);
            forward = forward.replace("awardBudgetVersions.do?", "awardBudgetParameters.do?syncBudgetRate=Y&");
        }
        forward = StringUtils.replace((String)forward, (String)"awardBudgetVersions.do?", (String)("awardBudgetVersions.do?auditActivated=" + awardForm.isAuditActivated() + "&syncQuestionAsked=Y&"));
        return new ActionForward(forward, true);
    }

    public ActionForward copyBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm pdForm = (AwardForm)form;
        Budget versionToCopy = this.getSelectedVersion(pdForm, request);
        if (!this.getAwardBudgetService().validateAddingNewBudget(pdForm.getAwardDocument())) {
            return mapping.findForward("basic");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("questionIndex"))) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("1".equals(buttonClicked)) {
                pdForm.setSaveAfterCopy(true);
                return this.copyBudgetPeriodOne(mapping, form, request, response);
            }
            if ("0".equals(buttonClicked)) {
                pdForm.setSaveAfterCopy(true);
                return this.copyBudgetAllPeriods(mapping, form, request, response);
            }
            return mapping.findForward("basic");
        }
        return this.performQuestionWithoutInput(mapping, form, request, response, "copyBudgetQuestion", "A new version of the budget will be created based on version " + versionToCopy.getBudgetVersionNumber() + ".", "copyPeriodsQuestion", pdForm.getMethodToCall(), "");
    }

    public ActionForward copyBudgetPeriodOne(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward copyBudgetAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, false);
        }
        return mapping.findForward("basic");
    }

    private Budget getSelectedVersion(AwardForm proposalDevelopmentForm, HttpServletRequest request) {
        return proposalDevelopmentForm.getAwardDocument().getBudgetDocumentVersion(this.getSelectedLine(request));
    }

    private void copyBudget(ActionForm form, HttpServletRequest request, boolean copyPeriodOneOnly) throws WorkflowException {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDoc = awardForm.getAwardDocument();
        Budget budgetToCopy = this.getSelectedVersion(awardForm, request);
        AwardBudgetDocument budgetDocToCopy = (AwardBudgetDocument)this.getDocumentService().getByDocumentHeaderId(budgetToCopy.getDocumentNumber());
        AwardBudgetDocument newBudget = this.getAwardBudgetService().copyBudgetVersion(budgetDocToCopy, copyPeriodOneOnly);
        awardDoc.getAward().getBudgets().add(newBudget.getAwardBudget());
        awardDoc.getAward().getCurrentVersionBudgets().add(newBudget.getAwardBudget());
        newBudget.getBudget().setNameUpdatable(true);
        newBudget.getBudget().setName(budgetToCopy.getName() + " " + budgetToCopy.getBudgetVersionNumber() + " copy");
    }

    private StrutsConfirmation syncBudgetRateConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNCH_BUDGET_RATE, message, "");
    }

    @Override
    public BudgetService getBudgetService() {
        return KcServiceLocator.getService(BudgetService.class);
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (AwardForm)form, true);
        AuditHelper.ValidationState state = KcServiceLocator.getService(AuditHelper.class).isValidSubmission((AwardForm)form, false);
        if (state == AuditHelper.ValidationState.ERROR) {
            actionForward = mapping.findForward("awardActions");
        }
        return actionForward;
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    @Override
    public DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = KcServiceLocator.getService(DocumentService.class);
        }
        return this.documentService;
    }
}

