/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.meeting.CommScheduleMinuteDocBase;
import org.kuali.coeus.common.committee.impl.meeting.ScheduleAgendaBase;
import org.kuali.coeus.common.committee.impl.notification.AgendaCreatedNotificationRenderer;
import org.kuali.coeus.common.committee.impl.notification.CommitteeNotificationContext;
import org.kuali.coeus.common.committee.impl.notification.MinutesCreatedNotificationRenderer;
import org.kuali.coeus.common.committee.impl.service.CommonCommitteeNotificationService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;

public class CommitteeNotificationServiceImpl
implements CommonCommitteeNotificationService {
    private String committeeNotificationType;
    private KcNotificationService kcNotificationService;

    public String getCommitteeNotificationType() {
        return this.committeeNotificationType;
    }

    public void setCommitteeNotificationType(String committeeNotificationType) {
        this.committeeNotificationType = committeeNotificationType;
    }

    @Override
    public void generateNotification(String notificationType, ScheduleAgendaBase agenda) {
        if (!StringUtils.equals((CharSequence)notificationType, (CharSequence)"213")) {
            throw new IllegalArgumentException(this.committeeNotificationType);
        }
        CommitteeScheduleBase committeeSchedule = agenda.getCommitteeSchedule();
        AgendaCreatedNotificationRenderer renderer = new AgendaCreatedNotificationRenderer(agenda, "action taken");
        CommitteeNotificationContext context = new CommitteeNotificationContext(committeeSchedule, notificationType, "Agenda Generated Notification", renderer);
        this.kcNotificationService.sendNotification(context);
    }

    @Override
    public void generateNotification(String notificationType, CommScheduleMinuteDocBase minuteDoc) {
        if (!StringUtils.equals((CharSequence)notificationType, (CharSequence)"215")) {
            throw new IllegalArgumentException(this.committeeNotificationType);
        }
        CommitteeScheduleBase committeeSchedule = minuteDoc.getCommitteeSchedule();
        MinutesCreatedNotificationRenderer renderer = new MinutesCreatedNotificationRenderer(minuteDoc, "action taken");
        CommitteeNotificationContext context = new CommitteeNotificationContext(committeeSchedule, notificationType, "Minutes Generated Notification", renderer);
        this.kcNotificationService.sendNotification(context);
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }
}

