/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.UnitAdministratorPersonMassChangeService;
import org.kuali.kra.personmasschange.service.impl.MassPersonChangeServiceBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.springframework.stereotype.Component;

@Component(value="unitAdministratorPersonMassChangeService")
public class UnitAdministratorPersonMassChangeServiceImpl
extends MassPersonChangeServiceBase
implements UnitAdministratorPersonMassChangeService {
    @Override
    public List<UnitAdministrator> getUnitAdministratorChangeCandidates(PersonMassChange personMassChange) {
        HashSet<UnitAdministrator> unitAdministratorChangeCandidates = new HashSet<UnitAdministrator>();
        ArrayList unitAdministrators = new ArrayList();
        if (personMassChange.getUnitAdministratorPersonMassChange().requiresChange()) {
            unitAdministrators.addAll(this.getBusinessObjectService().findAll(UnitAdministrator.class));
        }
        for (UnitAdministrator unitAdministrator : unitAdministrators) {
            if (!this.isUnitAdministratorChangeCandidate(personMassChange, unitAdministrator)) continue;
            unitAdministratorChangeCandidates.add(unitAdministrator);
        }
        return new ArrayList<UnitAdministrator>(unitAdministratorChangeCandidates);
    }

    private boolean isUnitAdministratorChangeCandidate(PersonMassChange personMassChange, UnitAdministrator unitAdministrator) {
        boolean isUnitAdministratorChangeCandidate = false;
        if (personMassChange.getUnitAdministratorPersonMassChange().isAdministrativeOfficer()) {
            isUnitAdministratorChangeCandidate |= this.isChangeCandidate(personMassChange, unitAdministrator, "1");
        }
        if (personMassChange.getUnitAdministratorPersonMassChange().isOspAdministrator()) {
            isUnitAdministratorChangeCandidate |= this.isChangeCandidate(personMassChange, unitAdministrator, "2");
        }
        if (personMassChange.getUnitAdministratorPersonMassChange().isUnitHead()) {
            isUnitAdministratorChangeCandidate |= this.isChangeCandidate(personMassChange, unitAdministrator, "3");
        }
        if (personMassChange.getUnitAdministratorPersonMassChange().isDeanVP()) {
            isUnitAdministratorChangeCandidate |= this.isChangeCandidate(personMassChange, unitAdministrator, "4");
        }
        if (personMassChange.getUnitAdministratorPersonMassChange().isOtherIndividualToNotify()) {
            isUnitAdministratorChangeCandidate |= this.isChangeCandidate(personMassChange, unitAdministrator, "5");
        }
        if (personMassChange.getUnitAdministratorPersonMassChange().isAdministrativeContact()) {
            isUnitAdministratorChangeCandidate |= this.isChangeCandidate(personMassChange, unitAdministrator, "7");
        }
        if (personMassChange.getUnitAdministratorPersonMassChange().isFinancialContact()) {
            isUnitAdministratorChangeCandidate |= this.isChangeCandidate(personMassChange, unitAdministrator, "8");
        }
        return isUnitAdministratorChangeCandidate;
    }

    private boolean isChangeCandidate(PersonMassChange personMassChange, UnitAdministrator unitAdministrator, String ... unitAdministratorTypes) {
        return this.isUnitAdministratorOfType(unitAdministrator, unitAdministratorTypes) && this.isPersonIdMassChange(personMassChange, unitAdministrator.getPersonId());
    }

    private boolean isUnitAdministratorOfType(UnitAdministrator unitAdministrator, String ... unitAdministratorTypes) {
        boolean isUnitAdministratorOfType = false;
        for (String unitAdministratorType : unitAdministratorTypes) {
            if (!StringUtils.equals((CharSequence)unitAdministrator.getUnitAdministratorTypeCode(), (CharSequence)unitAdministratorType)) continue;
            isUnitAdministratorOfType = true;
            break;
        }
        return isUnitAdministratorOfType;
    }

    @Override
    public void performPersonMassChange(PersonMassChange personMassChange, List<UnitAdministrator> unitAdministratorChangeCandidates) {
        for (UnitAdministrator unitAdministratorChangeCandidate : unitAdministratorChangeCandidates) {
            UnitAdministrator newUnitAdministrator = new UnitAdministrator();
            newUnitAdministrator.setUnitNumber(unitAdministratorChangeCandidate.getUnitNumber());
            newUnitAdministrator.setPersonId(personMassChange.getReplacerPersonId());
            newUnitAdministrator.setUnitAdministratorTypeCode(unitAdministratorChangeCandidate.getUnitAdministratorTypeCode());
            this.getBusinessObjectService().delete((Object)unitAdministratorChangeCandidate);
            this.getBusinessObjectService().save((PersistableBusinessObject)newUnitAdministrator);
        }
    }

    @Override
    protected String getDocumentId(PersistableBusinessObject parent) {
        throw new RuntimeException("unimplemented");
    }

    @Override
    protected String getDocumentName() {
        throw new RuntimeException("unimplemented");
    }

    @Override
    protected String getWarningKey() {
        throw new RuntimeException("unimplemented");
    }
}

