/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.custom;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.SaveCustomDataEvent;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

public class AuditCustomDataEvent
extends SaveCustomDataEvent {
    private static final String CUSTOM_DATA_AUDIT_KEY = "CustomData";
    private static final String CUSTOM_DATA_AUDIT_ERRORS = "Errors";
    private static final String CUSTOM_DATA_AUDIT_WARNINGS = "Warnings";

    public AuditCustomDataEvent(KcTransactionalDocumentBase document) {
        super(document, true);
    }

    @Override
    public void reportError(CustomAttribute customAttribute, String propertyName, String errorKey, String ... errorParams) {
        this.reportErrorOrWarning(customAttribute, propertyName, errorKey, "Error", errorParams);
    }

    @Override
    public void reportWarning(CustomAttribute customAttribute, String propertyName, String errorKey, String ... errorParams) {
        this.reportErrorOrWarning(customAttribute, propertyName, errorKey, CUSTOM_DATA_AUDIT_WARNINGS, errorParams);
    }

    public void reportErrorOrWarning(CustomAttribute customAttribute, String propertyName, String errorKey, String errorCategory, String ... errorParams) {
        ArrayList<AuditError> auditErrors;
        String category = "Error".equals(errorCategory) ? CUSTOM_DATA_AUDIT_ERRORS : CUSTOM_DATA_AUDIT_WARNINGS;
        String key = CUSTOM_DATA_AUDIT_KEY + StringUtils.deleteWhitespace((String)customAttribute.getGroupName()) + category;
        AuditCluster auditCluster = this.getGlobalVariableService().getAuditErrorMap().get(key);
        if (auditCluster == null) {
            auditErrors = new ArrayList<AuditError>();
            auditCluster = new AuditCluster(customAttribute.getGroupName(), auditErrors, errorCategory);
            this.getGlobalVariableService().getAuditErrorMap().put(key, auditCluster);
        }
        auditErrors = auditCluster.getAuditErrorList();
        auditErrors.add(new AuditError(propertyName, errorKey, StringUtils.deleteWhitespace((String)("customData." + customAttribute.getGroupName())), errorParams));
    }
}

