/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.kuali.kra.iacuc.IacucSpecies;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;

public class IacucProtocolSpeciesStudyGroup
implements Serializable {
    private static final long serialVersionUID = -4597595947309461496L;
    private Integer speciesCode;
    private IacucSpecies iacucSpecies;
    private Integer iacucProtocolSpeciesId;
    private IacucProtocolSpecies iacucProtocolSpecies;
    private IacucProtocolStudyGroup iacucProtocolStudyGroup;
    private List<IacucProtocolStudyGroup> iacucProtocolStudyGroups;
    private List<IacucProtocolStudyGroupBean> responsibleProcedures;
    private Integer totalSpeciesCount = 0;
    private boolean allProceduresSelected;

    public IacucProtocolSpeciesStudyGroup() {
        this.setIacucProtocolStudyGroups(new ArrayList<IacucProtocolStudyGroup>());
        this.setResponsibleProcedures(new ArrayList<IacucProtocolStudyGroupBean>());
    }

    public Integer getSpeciesCode() {
        return this.speciesCode;
    }

    public void setSpeciesCode(Integer speciesCode) {
        this.speciesCode = speciesCode;
    }

    public IacucSpecies getIacucSpecies() {
        return this.iacucSpecies;
    }

    public void setIacucSpecies(IacucSpecies iacucSpecies) {
        this.iacucSpecies = iacucSpecies;
    }

    public String getGroupAndSpecies() {
        StringBuilder groupAndSpecies = new StringBuilder();
        HashSet<String> procedureGroups = new HashSet<String>();
        for (IacucProtocolStudyGroup iacucProtocolStudyGroup : this.getIacucProtocolStudyGroups()) {
            procedureGroups.add(iacucProtocolStudyGroup.getIacucProtocolSpecies().getSpeciesGroup());
        }
        groupAndSpecies.append(procedureGroups.toString());
        groupAndSpecies.append(" : ");
        groupAndSpecies.append(this.getIacucSpecies().getSpeciesName());
        return groupAndSpecies.toString();
    }

    public IacucProtocolStudyGroup getIacucProtocolStudyGroup() {
        return this.iacucProtocolStudyGroup;
    }

    public void setIacucProtocolStudyGroup(IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        this.iacucProtocolStudyGroup = iacucProtocolStudyGroup;
    }

    public List<IacucProtocolStudyGroup> getIacucProtocolStudyGroups() {
        return this.iacucProtocolStudyGroups;
    }

    public void setIacucProtocolStudyGroups(List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        this.iacucProtocolStudyGroups = iacucProtocolStudyGroups;
    }

    public List<IacucProtocolStudyGroupBean> getResponsibleProcedures() {
        return this.responsibleProcedures;
    }

    public void setResponsibleProcedures(List<IacucProtocolStudyGroupBean> responsibleProcedures) {
        this.responsibleProcedures = responsibleProcedures;
    }

    public Integer getTotalSpeciesCount() {
        return this.totalSpeciesCount;
    }

    public void setTotalSpeciesCount(Integer totalSpeciesCount) {
        this.totalSpeciesCount = totalSpeciesCount;
    }

    public Integer getIacucProtocolSpeciesId() {
        return this.iacucProtocolSpeciesId;
    }

    public void setIacucProtocolSpeciesId(Integer iacucProtocolSpeciesId) {
        this.iacucProtocolSpeciesId = iacucProtocolSpeciesId;
    }

    public IacucProtocolSpecies getIacucProtocolSpecies() {
        return this.iacucProtocolSpecies;
    }

    public void setIacucProtocolSpecies(IacucProtocolSpecies iacucProtocolSpecies) {
        this.iacucProtocolSpecies = iacucProtocolSpecies;
    }

    public boolean isAllProceduresSelected() {
        return this.allProceduresSelected;
    }

    public void setAllProceduresSelected(boolean allProceduresSelected) {
        this.allProceduresSelected = allProceduresSelected;
    }

    public void addSpeciesCount(Integer speciesCount) {
        this.totalSpeciesCount = this.totalSpeciesCount + speciesCount;
    }
}

