/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.specialreview.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewService;
import org.kuali.rice.krad.data.DataObjectService;

public abstract class ProtocolSpecialReviewServiceImplBase
implements ProtocolSpecialReviewService {
    private transient ProtocolFinderDao protocolFinderDao;
    private DataObjectService dataObjectService;

    @Override
    public void populateSpecialReview(SpecialReview specialReview) {
        String protocolNumber = specialReview.getProtocolNumber();
        if (protocolNumber == null) {
            return;
        }
        String lastApprovedProtocolNumber = protocolNumber;
        if (StringUtils.contains((CharSequence)protocolNumber, (CharSequence)ProtocolSpecialVersion.AMENDMENT.getCode())) {
            lastApprovedProtocolNumber = StringUtils.substringBefore((String)protocolNumber, (String)ProtocolSpecialVersion.AMENDMENT.getCode());
        } else if (StringUtils.contains((CharSequence)protocolNumber, (CharSequence)ProtocolSpecialVersion.RENEWAL.getCode())) {
            lastApprovedProtocolNumber = StringUtils.substringBefore((String)protocolNumber, (String)ProtocolSpecialVersion.RENEWAL.getCode());
        }
        ProtocolBase protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(lastApprovedProtocolNumber);
        if (protocol != null) {
            this.setSpecialReviewApprovalTypeHook(specialReview);
            if (specialReview.getClass().equals(ProposalSpecialReview.class)) {
                ProposalSpecialReview psr = (ProposalSpecialReview)specialReview;
                DevelopmentProposal dp = this.getPropososalDevelopment(psr.getDevelopmentProposal().getProposalNumber());
                if (!(dp != null && (StringUtils.equals((CharSequence)dp.getProposalStateTypeCode(), (CharSequence)"6") || StringUtils.equals((CharSequence)dp.getProposalStateTypeCode(), (CharSequence)"7") || StringUtils.equals((CharSequence)dp.getProposalStateTypeCode(), (CharSequence)"8") || StringUtils.equals((CharSequence)dp.getProposalStateTypeCode(), (CharSequence)"9") || StringUtils.equals((CharSequence)dp.getProposalStateTypeCode(), (CharSequence)"5")) && specialReview.getProtocolStatus() != null)) {
                    specialReview.setProtocolStatus(protocol.getProtocolStatus().getDescription());
                }
            } else {
                specialReview.setProtocolStatus(protocol.getProtocolStatus().getDescription());
            }
            specialReview.setProtocolNumber(protocol.getProtocolNumber());
            specialReview.setApplicationDate(protocol.getProtocolSubmission().getSubmissionDate());
            specialReview.setApprovalDate(protocol.getLastApprovalDate() == null ? protocol.getApprovalDate() : protocol.getLastApprovalDate());
            specialReview.setExpirationDate(protocol.getExpirationDate());
            this.setProtocolExemptStudiesCheckListItemHook(protocol, specialReview);
            specialReview.setLinkedToProtocol(true);
        }
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Override
    public DevelopmentProposal getPropososalDevelopment(String proposalNumber) {
        DevelopmentProposal dp = null;
        if (proposalNumber != null) {
            dp = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)proposalNumber);
        }
        return dp;
    }

    @Override
    public ProtocolFinderDao getProtocolFinderDao() {
        if (this.protocolFinderDao == null) {
            this.protocolFinderDao = KcServiceLocator.getService(ProtocolFinderDao.class);
        }
        return this.protocolFinderDao;
    }

    @Override
    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    protected abstract void setSpecialReviewApprovalTypeHook(SpecialReview var1);

    protected abstract void setProtocolExemptStudiesCheckListItemHook(ProtocolBase var1, SpecialReview var2);
}

