/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.notification;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.IacucProtocolActionType;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewType;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionQualifierType;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionType;
import org.kuali.kra.iacuc.committee.bo.IacucCommittee;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRendererBase;

public class IacucProtocolNotificationRenderer
extends ProtocolNotificationRendererBase {
    private static final long serialVersionUID = 44807703047564273L;
    private static final String PROTOCOL_ACTION_TYPE_CODE = "protocolActionTypeCode";
    private static final String SUBMISSION_TYPE_CODE = "submissionTypeCode";
    private static final String SUBMISSION_QUALIFIER_TYPE_CODE = "submissionQualifierTypeCode";
    private static final String REVIEW_TYPE_CODE = "reviewTypeCode";

    public IacucProtocolNotificationRenderer(IacucProtocol protocol) {
        super(protocol);
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        Map<String, String> params = super.getDefaultReplacementParameters();
        IacucProtocolSubmission protocolSubmission = (IacucProtocolSubmission)this.getProtocol().getProtocolSubmission();
        if (protocolSubmission != null) {
            params.put("{LAST_SUBMISSION_NAME}", this.getProtocolSubmissionName(protocolSubmission.getSubmissionTypeCode()));
            params.put("{LAST_SUBMISSION_TYPE_QUAL_NAME}", this.getLastSubmissionTypeQualifierName(protocolSubmission.getSubmissionTypeQualifierCode()));
            params.put("{PROTOCOL_REVIEW_TYPE_DESC}", this.getSafeMessage("{PROTOCOL_REVIEW_TYPE_DESC}", this.getProtocolReviewTypeDescription(protocolSubmission.getProtocolReviewTypeCode())));
        } else {
            params.put("{LAST_SUBMISSION_NAME}", "");
            params.put("{LAST_SUBMISSION_TYPE_QUAL_NAME}", "");
            params.put("{PROTOCOL_REVIEW_TYPE_DESC}", "");
        }
        ProtocolActionBase lastProtocolAction = this.getProtocol().getLastProtocolAction();
        if (lastProtocolAction != null) {
            params.put("{LAST_ACTION_NAME}", this.getProtocolLastActionName(lastProtocolAction.getProtocolActionTypeCode()));
            params.put("{LAST_ACTION_TYPE_CODE}", lastProtocolAction.getProtocolActionTypeCode());
        } else {
            params.put("{LAST_ACTION_NAME}", "");
            params.put("{LAST_ACTION_TYPE_CODE}", "");
        }
        return params;
    }

    private String getProtocolLastActionName(String lastActionTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(PROTOCOL_ACTION_TYPE_CODE, lastActionTypeCode);
        List actionTypes = (List)this.getBusinessObjectService().findMatching(IacucProtocolActionType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)actionTypes)) {
            result = ((IacucProtocolActionType)actionTypes.get(0)).getDescription();
        }
        return result;
    }

    private String getProtocolSubmissionName(String submissionTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SUBMISSION_TYPE_CODE, submissionTypeCode);
        List submissionTypes = (List)this.getBusinessObjectService().findMatching(IacucProtocolSubmissionType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)submissionTypes)) {
            result = ((IacucProtocolSubmissionType)submissionTypes.get(0)).getDescription();
        }
        return result;
    }

    private String getLastSubmissionTypeQualifierName(String submissionQualifierTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SUBMISSION_QUALIFIER_TYPE_CODE, submissionQualifierTypeCode);
        List submissionQualifierTypes = (List)this.getBusinessObjectService().findMatching(IacucProtocolSubmissionQualifierType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)submissionQualifierTypes)) {
            result = ((IacucProtocolSubmissionQualifierType)submissionQualifierTypes.get(0)).getDescription();
        }
        return result;
    }

    private String getProtocolReviewTypeDescription(String reviewTypeCode) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(REVIEW_TYPE_CODE, reviewTypeCode);
        List protocolReviewTypes = (List)this.getBusinessObjectService().findMatching(IacucProtocolReviewType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)protocolReviewTypes)) {
            result = ((IacucProtocolReviewType)protocolReviewTypes.get(0)).getDescription();
        }
        return result;
    }

    @Override
    protected Class<? extends CommitteeBase> getCommonCommitteeBOClassHook() {
        return IacucCommittee.class;
    }
}

