/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.committee.impl.lookup.keyvalue.CommitteeIdByUnitValuesFinderService;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeIdByUnitValuesFinderServiceImplBase<CMT extends CommitteeBase<CMT, ?, ?>>
implements CommitteeIdByUnitValuesFinderService<CMT> {
    private static final long serialVersionUID = -3005003472800028011L;
    public static final String FINAL_STATUS_CD = "F";
    private static final String COMMITTEE_TYPE_CODE = "committeeTypeCode";
    private UnitAuthorizationService unitAuthorizationService;
    private UnitService unitService;
    private BusinessObjectService businessObjectService;

    @Override
    public Collection<CMT> getAssignmentCommittees(String protocolLeadUnit, String docRouteStatus, String currentCommitteeId) {
        ArrayList<CommitteeBase> assignmentCommittees;
        block4: {
            assignmentCommittees = new ArrayList<CommitteeBase>();
            Collection<CMT> candidateCommittees = this.getCandidateCommittees();
            if (!CollectionUtils.isNotEmpty(candidateCommittees)) break block4;
            if (this.isSaved(docRouteStatus)) {
                Set<String> unitIds = this.getProtocolUnitIds(protocolLeadUnit);
                for (CommitteeBase committee : candidateCommittees) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)((CommitteeDocumentBase)committee.getCommitteeDocument()).getDocStatusCode(), (CharSequence)FINAL_STATUS_CD) || !unitIds.contains(committee.getHomeUnit().getUnitNumber())) continue;
                    assignmentCommittees.add(committee);
                }
            } else {
                String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
                for (CommitteeBase committee : candidateCommittees) {
                    if (!this.isCurrentUserAuthorizedToAssignThisCommittee(principalId, committee) && !committee.getCommitteeId().equals(currentCommitteeId)) continue;
                    assignmentCommittees.add(committee);
                }
            }
        }
        return assignmentCommittees;
    }

    private Collection<CMT> getCandidateCommittees() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(COMMITTEE_TYPE_CODE, this.getCommitteeTypeCodeHook());
        Collection allCommittees = this.getBusinessObjectService().findMatching(this.getCommitteeBOClassHook(), criteria);
        HashMap<String, CommitteeBase> committeeMap = new HashMap<String, CommitteeBase>();
        CommitteeBase tmpComm = null;
        for (CommitteeBase comm : allCommittees) {
            if (!FINAL_STATUS_CD.equalsIgnoreCase(((CommitteeDocumentBase)comm.getCommitteeDocument()).getDocStatusCode())) continue;
            if (committeeMap.containsKey(comm.getCommitteeId())) {
                tmpComm = (CommitteeBase)committeeMap.get(comm.getCommitteeId());
                if (comm.getSequenceNumber() <= tmpComm.getSequenceNumber()) continue;
                committeeMap.put(comm.getCommitteeId(), comm);
                continue;
            }
            committeeMap.put(comm.getCommitteeId(), comm);
        }
        return committeeMap.values();
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    protected abstract Class<CMT> getCommitteeBOClassHook();

    protected abstract String getCommitteeTypeCodeHook();

    protected boolean isCurrentUserAuthorizedToAssignThisCommittee(String userId, CMT candidateCommittee) {
        String permissionNamespace = this.getAssignCommitteePermissionNamespaceHook();
        String permissionName = this.getAssignCommitteePermissionNameHook();
        boolean retVal = this.getUnitAuthorizationService().hasPermission(userId, ((CommitteeBase)candidateCommittee).getHomeUnitNumber(), permissionNamespace, permissionName);
        return retVal;
    }

    protected abstract String getAssignCommitteePermissionNamespaceHook();

    protected abstract String getAssignCommitteePermissionNameHook();

    protected UnitAuthorizationService getUnitAuthorizationService() {
        if (this.unitAuthorizationService == null) {
            this.unitAuthorizationService = KcServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    private boolean isSaved(String docRouteStatus) {
        return docRouteStatus.equals("S");
    }

    private Set<String> getProtocolUnitIds(String protocolLeadUnit) {
        Set<String> unitIds = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)protocolLeadUnit)) {
            unitIds.add(protocolLeadUnit);
            List<Unit> subUnits = this.getUnitService().getAllSubUnits(protocolLeadUnit);
            for (Unit unit : subUnits) {
                unitIds.add(unit.getUnitNumber());
            }
            String topUnitNumber = this.getUnitService().getTopUnit().getUnitNumber();
            unitIds = this.getParentUnitIds(protocolLeadUnit, topUnitNumber, unitIds);
        }
        return unitIds;
    }

    private Set<String> getParentUnitIds(String currentUnitNumber, String topUnitNumber, Set<String> unitIds) {
        while (!currentUnitNumber.equals(topUnitNumber)) {
            String parentUnitNumber = this.getUnitService().getUnit(currentUnitNumber).getParentUnitNumber();
            Unit parentUnit = this.getUnitService().getUnit(parentUnitNumber);
            unitIds.add(parentUnit.getUnitNumber());
            currentUnitNumber = parentUnit.getUnitNumber();
        }
        return unitIds;
    }

    protected UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }
}

