/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.org.crrspndnt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.org.OrganizationService;
import org.kuali.coeus.common.framework.org.crrspndnt.OrganizationCorrespondent;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kew.api.identity.Id;
import org.kuali.rice.kew.api.identity.PrincipalId;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.GenericRoleAttribute;
import org.kuali.rice.kew.rule.QualifiedRoleName;
import org.w3c.dom.NodeList;

public class OrganizationCorrespondentRoleAttribute
extends GenericRoleAttribute {
    private static final String ROLE_NAME = "OrganizationCorrespondent";
    private static final String ORGANIZATION_ID = "organizationId";

    public List<String> getQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        ArrayList<String> qualifiedRoleNames = new ArrayList<String>();
        qualifiedRoleNames.add(ROLE_NAME);
        return qualifiedRoleNames;
    }

    public List<RoleName> getRoleNames() {
        RoleName role = RoleName.Builder.create((String)OrganizationCorrespondentRoleAttribute.class.getName(), (String)ROLE_NAME, (String)ROLE_NAME).build();
        return Collections.singletonList(role);
    }

    public Map<String, String> getProperties() {
        return null;
    }

    private OrganizationService getOrganizationService() {
        return KcServiceLocator.getService(OrganizationService.class);
    }

    protected List<Id> resolveRecipients(RouteContext routeContext, QualifiedRoleName qualifiedRoleName) {
        ArrayList<Id> members = new ArrayList<Id>();
        DocumentContent dc = routeContext.getDocumentContent();
        NodeList nodes = dc.getDocument().getElementsByTagName(ORGANIZATION_ID);
        String orgId = nodes.item(0).getTextContent();
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            List<OrganizationCorrespondent> organizationCorrespondents = this.getOrganizationService().retrieveOrganizationCorrespondentsByOrganizationId(orgId);
            for (OrganizationCorrespondent organizationCorrespondent : organizationCorrespondents) {
                if (!StringUtils.isNotBlank((CharSequence)organizationCorrespondent.getPersonId())) continue;
                members.add((Id)new PrincipalId(organizationCorrespondent.getPersonId()));
            }
        }
        return members;
    }
}

