/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview.rules;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBaseExtension;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.kra.protocol.onlinereview.event.AddProtocolOnlineReviewCommentEvent;
import org.kuali.kra.protocol.onlinereview.event.DeleteProtocolOnlineReviewEvent;
import org.kuali.kra.protocol.onlinereview.event.DisapproveProtocolOnlineReviewCommentEvent;
import org.kuali.kra.protocol.onlinereview.event.RejectProtocolOnlineReviewCommentEvent;
import org.kuali.kra.protocol.onlinereview.event.RouteProtocolOnlineReviewEvent;
import org.kuali.kra.protocol.onlinereview.event.SaveProtocolOnlineReviewEvent;
import org.kuali.kra.protocol.onlinereview.rules.AddOnlineReviewCommentRule;
import org.kuali.kra.protocol.onlinereview.rules.DeleteOnlineReviewRule;
import org.kuali.kra.protocol.onlinereview.rules.DisapproveOnlineReviewCommentRule;
import org.kuali.kra.protocol.onlinereview.rules.RejectOnlineReviewCommentRule;
import org.kuali.kra.protocol.onlinereview.rules.RouteProtocolOnlineReviewRule;
import org.kuali.kra.protocol.onlinereview.rules.SaveProtocolOnlineReviewRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolOnlineReviewDocumentRule
extends KcTransactionalDocumentRuleBase
implements AddOnlineReviewCommentRule,
SaveProtocolOnlineReviewRule,
KcBusinessRule,
RouteProtocolOnlineReviewRule,
DisapproveOnlineReviewCommentRule,
RejectOnlineReviewCommentRule,
DeleteOnlineReviewRule {
    private static final String ONLINE_REVIEW_COMMENTS_ERROR_PATH = "onlineReviewsActionHelper.reviewCommentsBeans[%s]";
    private static final String ONLINE_REVIEW_ATTACHMENTS_ERROR_PATH = "onlineReviewsActionHelper.reviewAttachmentsBeans[%s]";
    private static final String ONLINE_REVIEW_ERROR_PATH = "onlineReviewsActionHelper.protocolOnlineReviewDocuments[%s].protocolOnlineReview";

    public boolean processAddProtocolOnlineReviewComment(IacucProtocolOnlineReview protocolOnlineReview, CommitteeScheduleMinuteBase minute) {
        return false;
    }

    @Override
    public boolean processAddProtocolOnlineReviewComment(AddProtocolOnlineReviewCommentEvent event) {
        boolean valid = true;
        CommitteeScheduleMinuteBase minute = event.getCommitteeScheduleMinute();
        if (StringUtils.isEmpty((CharSequence)minute.getMinuteEntry()) && StringUtils.isEmpty((CharSequence)minute.getProtocolContingencyCode())) {
            valid = false;
            GlobalVariables.getMessageMap().clearErrorPath();
            GlobalVariables.getMessageMap().addToErrorPath(String.format(ONLINE_REVIEW_COMMENTS_ERROR_PATH, event.getOnlineReviewIndex()));
            GlobalVariables.getMessageMap().putError("newReviewComment.minuteEntry", "error.protocol.onlinereview.comment.required", new String[0]);
        }
        return valid;
    }

    @Override
    public boolean processSaveProtocolOnlineReview(SaveProtocolOnlineReviewEvent event) {
        boolean valid = true;
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath(String.format(ONLINE_REVIEW_COMMENTS_ERROR_PATH, event.getOnlineReviewIndex()));
        ProtocolOnlineReviewBase protocolOnlineReview = event.getProtocolOnlineReviewDocument().getProtocolOnlineReview();
        int index = 0;
        for (CommitteeScheduleMinuteBase minute : event.getMinutes()) {
            if (StringUtils.isEmpty((CharSequence)minute.getMinuteEntry()) && StringUtils.isEmpty((CharSequence)minute.getProtocolContingencyCode())) {
                valid = false;
                GlobalVariables.getMessageMap().putError(String.format("reviewComments[%s].minuteEntry", index), "error.protocol.onlinereview.comment.required", new String[0]);
            }
            ++index;
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath(String.format(ONLINE_REVIEW_ATTACHMENTS_ERROR_PATH, event.getOnlineReviewIndex()));
        index = 0;
        for (ProtocolReviewAttachmentBase reviewAttachment : event.getReviewAttachments()) {
            if (StringUtils.isEmpty((CharSequence)reviewAttachment.getDescription())) {
                valid = false;
                GlobalVariables.getMessageMap().putError(String.format("reviewAttachments[%s].description", index), "error.protocol.onlinereview.attachment.description.required", new String[0]);
            }
            ++index;
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath(String.format(ONLINE_REVIEW_ERROR_PATH, event.getOnlineReviewIndex()));
        if (StringUtils.isEmpty((CharSequence)protocolOnlineReview.getProtocolOnlineReviewStatusCode())) {
            GlobalVariables.getMessageMap().putError("protocolOnlineReviewStatusCode", "error.protocol.onlinereview.status.required", new String[0]);
            valid = false;
        }
        if (protocolOnlineReview.getDateRequested() != null && protocolOnlineReview.getDateDue() != null && !DateUtils.isSameDay(protocolOnlineReview.getDateDue(), protocolOnlineReview.getDateRequested()) && !protocolOnlineReview.getDateDue().after(protocolOnlineReview.getDateRequested())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("protocolOnlineReviewDueDate", "error.protocol.onlinereview.create.dueDateAfterRequestedDate", new String[0]);
        }
        return valid;
    }

    @Override
    public boolean processRouteProtocolOnlineReview(RouteProtocolOnlineReviewEvent event) {
        boolean valid = true;
        KualiRuleService ruleService = KcServiceLocator.getService(KualiRuleService.class);
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath(String.format(ONLINE_REVIEW_COMMENTS_ERROR_PATH, event.getOnlineReviewIndex()));
        return valid &= ruleService.applyRules((DocumentEvent)new SaveProtocolOnlineReviewEvent(event.getProtocolOnlineReviewDocument(), event.getMinutes(), event.getOnlineReviewIndex()));
    }

    @Override
    public boolean processDisapproveOnlineReviewComment(DisapproveProtocolOnlineReviewCommentEvent event) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)event.getReason()) || event.getNoteText().length() > event.getMaxLength()) {
            valid = false;
        }
        return valid;
    }

    @Override
    public boolean processRejectOnlineReviewComment(RejectProtocolOnlineReviewCommentEvent event) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)event.getReason()) || event.getReason().length() > event.getMaxLength()) {
            valid = false;
        }
        return valid;
    }

    @Override
    public boolean processDeleteOnlineReview(DeleteProtocolOnlineReviewEvent event) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)event.getReason()) || event.getNoteText().length() > event.getMaxLength()) {
            valid = false;
        }
        return valid;
    }

    public boolean processRules(KcDocumentEventBaseExtension event) {
        boolean retVal = false;
        retVal = event.getRule().processRules(event);
        return retVal;
    }
}

