/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.hr.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.hr.impl.DOMHRImport;
import org.kuali.coeus.hr.impl.HRImport;
import org.kuali.coeus.hr.impl.HRImportService;
import org.kuali.coeus.hr.impl.ImportError;
import org.kuali.coeus.hr.impl.ImportRunner;
import org.kuali.coeus.hr.impl.ImportStatus;
import org.kuali.coeus.hr.impl.ImportStatusService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/hrimport"})
public class HRImportController {
    private static final Logger LOG = LogManager.getLogger(HRImportController.class);
    public static final String SCHEMA_PATH = "/hrmanifest.xsd";
    public static final String HR_IMPORT_IN_MEMORY = "hrimport.inMemory";
    @Autowired
    @Qualifier(value="hrImportService")
    protected HRImportService importService;
    @Autowired
    @Qualifier(value="importRunner")
    protected ImportRunner importRunner;
    @Autowired
    @Qualifier(value="importStatusService")
    protected ImportStatusService statusService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    protected ConfigurationService configurationService;
    protected JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DOMHRImport.class});
    protected Schema hrImportSchema;
    protected Unmarshaller hrImportUnmarshaller;

    public HRImportController() throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.hrImportSchema = sf.newSchema(new StreamSource(this.getClass().getResourceAsStream(SCHEMA_PATH)));
        LOG.debug("schema loaded from /hrmanifest.xsd");
        this.hrImportUnmarshaller = this.jaxbContext.createUnmarshaller();
        this.hrImportUnmarshaller.setSchema(this.hrImportSchema);
    }

    public String statusToJson(ImportStatus status) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("\"importId\":\"").append(status.getImportId()).append("\",");
        sb.append("\"status\":\"").append((Object)status.getStatus()).append("\",");
        String msg = status.getMessage();
        if (msg != null) {
            sb.append("\"message\":\"").append(msg).append("\",");
        }
        sb.append("\"startTime\":\"").append(status.getStartTimeInMillis()).append("\",");
        long end = status.getEndTimeInMillis();
        if (end > 0L) {
            sb.append("\"endTime\":\"").append(end).append("\",");
        }
        sb.append("\"recordTotal\":\"").append(status.getRecordTotal()).append("\",");
        sb.append("\"processedRecords\":\"").append(status.getProcessedRecordCount()).append("\",");
        int errorCount = status.getErrorCount();
        sb.append("\"errorCount\":\"").append(errorCount).append("\"");
        if (errorCount > 0) {
            sb.append(",\"errors\":[");
            List<ImportError> errors = status.getErrors();
            String separator = "";
            for (ImportError error : errors) {
                sb.append(separator);
                separator = ",";
                sb.append("{\"recordNumber\":\"").append(error.getRecordNumber()).append("\",");
                sb.append("\"principalName\":\"").append(error.getPrincipalName()).append("\",");
                sb.append("\"exception\":{\"type\":\"").append("hr-import-error").append("\",");
                sb.append("\"message\":\"").append(error.getException()).append("\"}}");
            }
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }

    protected final boolean runInMemory() {
        return this.getConfigurationService().getPropertyValueAsBoolean(HR_IMPORT_IN_MEMORY);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/import"}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseEntity<String> processImport(@RequestParam(value="file", required=false) MultipartFile uploadedFile) throws Exception {
        ResponseEntity res;
        if (uploadedFile == null) {
            LOG.error("import called without file argument");
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
        }
        InputStream uploadedInputStream = uploadedFile.getInputStream();
        File tempFile = File.createTempFile("hrimport", Long.toString(new Date().getTime()));
        LOG.debug("writing uploaded HR import to : " + tempFile.getAbsolutePath());
        try {
            int read;
            FileOutputStream out = new FileOutputStream(tempFile);
            byte[] bytes = new byte[32768];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            LOG.error("Error while processing an hrimport file upload", (Throwable)e);
            throw e;
        }
        String importId = UUID.randomUUID().toString();
        LOG.debug("initiating import with ID: " + importId);
        try {
            ImportStatus status;
            ImportRunner runner = this.getImportRunner();
            if (this.runInMemory()) {
                HRImport toImport = (HRImport)this.hrImportUnmarshaller.unmarshal(tempFile);
                status = runner.processImport(importId, toImport);
            } else {
                status = runner.processImport(importId, tempFile.getAbsolutePath());
            }
            res = ResponseEntity.ok().body((Object)this.statusToJson(status));
        }
        catch (Exception e) {
            res = ResponseEntity.status((int)500).build();
            LOG.error("Import failed ", (Throwable)e);
        }
        return res;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/import/{importId}"})
    public ResponseEntity<String> abort(@PathVariable String importId) {
        ResponseEntity res;
        try {
            ImportRunner runner = this.getImportRunner();
            runner.abort(importId);
            res = ResponseEntity.ok().build();
        }
        catch (Exception e) {
            res = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        return res;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/import/{importId}"})
    public ResponseEntity<String> status(@PathVariable String importId) {
        ResponseEntity res;
        try {
            ImportStatus status = this.getStatusService().getImportStatus(importId);
            res = status == null ? ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build() : ResponseEntity.ok().body((Object)this.statusToJson(status));
        }
        catch (Exception e) {
            res = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        return res;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/delete/{entityId}"})
    public ResponseEntity<String> deleteRecord(@PathVariable String entityId) {
        try {
            this.getImportService().deletePerson(entityId);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        return ResponseEntity.ok().build();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/principals/unmanaged"})
    public ResponseEntity<String> unmanagedPrincipals() {
        try {
            List<String> names = this.getStatusService().getPrincipalNamesUnmanagedByHRImport();
            StringBuilder sb = new StringBuilder();
            boolean comma = false;
            sb.append('[');
            for (String name : names) {
                if (comma) {
                    sb.append(',');
                }
                comma = true;
                sb.append('\"').append(name).append('\"');
            }
            sb.append(']');
            return ResponseEntity.ok((Object)sb.toString());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    public HRImportService getImportService() {
        return this.importService;
    }

    public void setImportService(HRImportService importService) {
        this.importService = importService;
    }

    public ImportStatusService getStatusService() {
        return this.statusService;
    }

    public void setStatusService(ImportStatusService svc) {
        this.statusService = svc;
    }

    public ImportRunner getImportRunner() {
        return this.importRunner;
    }

    public void setImportRunner(ImportRunner runner) {
        this.importRunner = runner;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

