/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolPersonnelAuditRuleBase
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private List<AuditError> auditErrors;
    private static final String PERSONNEL_AUDIT_ERRORS = "personnelAuditErrors";

    public boolean processRunAuditBusinessRules(Document document) {
        boolean isValid = true;
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        this.auditErrors = new ArrayList<AuditError>();
        isValid = this.getProtocolPersonnelService().isValidStudentFacultyMatch(protocolDocument.getProtocol().getProtocolPersons());
        if (!isValid) {
            for (Integer errorIndex : this.getProtocolPersonnelService().getAffiliationStudentMap(protocolDocument.getProtocol().getProtocolPersons())) {
                this.addErrorToAuditErrors(errorIndex);
            }
        }
        this.reportAndCreateAuditCluster();
        return isValid;
    }

    protected void addErrorToAuditErrors(int personIndex) {
        String label = "document.protocolList[0].protocolPersons[" + personIndex + "].protocolPersonRoleId";
        String cat = "personnel.Add Personnel:";
        this.auditErrors.add(new AuditError(label, "error.protocol.investigator.invalid", cat));
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(PERSONNEL_AUDIT_ERRORS, new AuditCluster("Personnel", this.auditErrors, "Error"));
        }
    }

    protected abstract ProtocolPersonnelService getProtocolPersonnelService();
}

