/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

@ParameterConstants.NAMESPACE(namespace="KC-IACUC")
@ParameterConstants.COMPONENT(component="Document")
public class IacucProtocolOnlineReviewDocument
extends ProtocolOnlineReviewDocumentBase {
    private static final long serialVersionUID = 43793212884887769L;
    private static final String DOCUMENT_TYPE_CODE = "PTRV";
    private static final Logger LOG = LogManager.getLogger(IacucProtocolOnlineReviewDocument.class);
    private static final String OLR_DOC_ID_PARAM = "olrDocId";
    private static final String OLR_EVENT_PARAM = "olrEvent";
    private List<IacucProtocolOnlineReview> protocolOnlineReviewList = new ArrayList<IacucProtocolOnlineReview>();

    public IacucProtocolOnlineReviewDocument() {
        IacucProtocolOnlineReview newProtocolReview = new IacucProtocolOnlineReview();
        newProtocolReview.setProtocolOnlineReviewDocument(this);
        this.protocolOnlineReviewList.add(newProtocolReview);
    }

    public String serializeDocumentToXml() {
        for (ProtocolOnlineReviewBase protocolOnlineReviewBase : this.getProtocolOnlineReviewList()) {
            ProtocolBase protocol = protocolOnlineReviewBase.getProtocol();
            protocol.getLeadUnitNumber();
        }
        return super.serializeDocumentToXml();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public ProtocolOnlineReviewBase getProtocolOnlineReview() {
        if (this.protocolOnlineReviewList.size() == 0) {
            return null;
        }
        return this.protocolOnlineReviewList.get(0);
    }

    @Override
    public void setProtocolOnlineReview(ProtocolOnlineReviewBase protocolOnlineReview) {
        this.protocolOnlineReviewList.set(0, (IacucProtocolOnlineReview)protocolOnlineReview);
    }

    public List<IacucProtocolOnlineReview> getProtocolOnlineReviewList() {
        return this.protocolOnlineReviewList;
    }

    public void setProtocolOnlineReviewList(List<IacucProtocolOnlineReview> protocolOnlineReviewList) {
        this.protocolOnlineReviewList = protocolOnlineReviewList;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        if (this.getProtocolOnlineReview() != null) {
            managedLists.addAll(this.getProtocolOnlineReview().buildListOfDeletionAwareLists());
        }
        managedLists.add(this.protocolOnlineReviewList);
        return managedLists;
    }

    @Override
    protected List<RolePersons> getAllRolePersons() {
        return new ArrayList<RolePersons>();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(statusChangeEvent);
            if (StringUtils.equals((CharSequence)statusChangeEvent.getNewRouteStatus(), (CharSequence)"X") || StringUtils.equals((CharSequence)statusChangeEvent.getNewRouteStatus(), (CharSequence)"D")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("ProtocolBase Online Review Document %s has been cancelled, deleting associated review comments.", this.getDocumentNumber()));
                }
                this.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("X");
                this.getBusinessObjectService().save((PersistableBusinessObject)this.getProtocolOnlineReview());
            }
            return null;
        });
    }

    @Override
    public void doActionTaken(ActionTakenEvent event) {
        this.executeAsLastActionUser(() -> {
            super.doActionTaken(event);
            return null;
        });
    }

    private BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(0L);
        }
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = true;
        String backLocation = (String)GlobalVariables.getUserSession().retrieveObject("holdingPageReturnLocation");
        String olrDocId = this.getURLParamValue(backLocation, OLR_DOC_ID_PARAM);
        if (olrDocId != null) {
            String olrEvent = this.getURLParamValue(backLocation, OLR_EVENT_PARAM);
            if (StringUtils.equalsIgnoreCase((CharSequence)olrEvent, (CharSequence)"Approve")) {
                isComplete = this.isOnlineReviewApproveComplete(olrDocId);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)olrEvent, (CharSequence)"Return")) {
                isComplete = this.isOnlineReviewRejectComplete(olrDocId);
            }
        }
        return isComplete;
    }

    private WorkflowDocumentService getWorkflowDocumentService() {
        return KRADServiceLocatorWeb.getWorkflowDocumentService();
    }

    private boolean isOnlineReviewApproveComplete(String olrDocId) {
        boolean isComplete = true;
        try {
            ProtocolOnlineReviewDocumentBase onlineReviewDoc = (ProtocolOnlineReviewDocumentBase)this.getDocumentService().getByDocumentHeaderId(olrDocId);
            if (this.getWorkflowDocumentService().getCurrentRouteNodeNames(onlineReviewDoc.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("IACUCOnlineReviewer")) {
                isComplete = false;
            }
        }
        catch (Exception e) {
            isComplete = true;
        }
        return isComplete;
    }

    private boolean isOnlineReviewRejectComplete(String olrDocId) {
        boolean isComplete = true;
        try {
            ProtocolOnlineReviewDocumentBase onlineReviewDoc = (ProtocolOnlineReviewDocumentBase)this.getDocumentService().getByDocumentHeaderId(olrDocId);
            if (!this.getWorkflowDocumentService().getCurrentRouteNodeNames(onlineReviewDoc.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("IACUCOnlineReviewer")) {
                isComplete = false;
            }
        }
        catch (Exception e) {
            isComplete = true;
        }
        return isComplete;
    }

    private DocumentService getDocumentService() {
        return KcServiceLocator.getService(DocumentService.class);
    }

    private String getURLParamValue(String url, String paramName) {
        String paramString;
        String pValue = null;
        if (StringUtils.isNotBlank((CharSequence)url) && url.contains("?") && StringUtils.isNotBlank((CharSequence)(paramString = url.substring(url.indexOf("?") + 1)))) {
            String[] params;
            for (String param : params = paramString.split("&")) {
                String[] temp = param.split("=");
                if (!StringUtils.equals((CharSequence)temp[0], (CharSequence)paramName)) continue;
                pValue = temp[1];
            }
        }
        return pValue;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return null;
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getProtocolOnlineReview().getProtocolId().toString();
    }
}

