/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.rules;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.rule.event.CommitteeScheduleDayEvent;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.ScheduleData;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.StyleKey;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;

public class CommitteeScheduleDayRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<CommitteeScheduleDayEvent> {
    public static final String SCHEDULEDATA_MONTHLY_DAY = "committeeHelper.scheduleData.monthlySchedule.day";
    public static final String SCHEDULEDATA_YEARLY_DAY = "committeeHelper.scheduleData.yearlySchedule.day";

    @Override
    public boolean processRules(CommitteeScheduleDayEvent event) {
        boolean rulePassed = true;
        ScheduleData scheduleData = event.getScheduleData();
        StyleKey key = StyleKey.valueOf(scheduleData.getRecurrenceType());
        switch (key) {
            case MONTHLY: {
                MonthlyScheduleDetails.optionValues monthOption = MonthlyScheduleDetails.optionValues.valueOf(scheduleData.getMonthlySchedule().getMonthOption());
                switch (monthOption) {
                    case XDAYANDXMONTH: {
                        rulePassed = this.validateDay(scheduleData.getMonthlySchedule().getDay(), SCHEDULEDATA_MONTHLY_DAY);
                    }
                }
                break;
            }
            case YEARLY: {
                YearlyScheduleDetails.yearOptionValues yearOption = YearlyScheduleDetails.yearOptionValues.valueOf(scheduleData.getYearlySchedule().getYearOption());
                switch (yearOption) {
                    case XDAY: {
                        rulePassed = this.validateDay(scheduleData.getYearlySchedule().getDay(), scheduleData.getYearlySchedule().getSelectedOption1Month(), SCHEDULEDATA_YEARLY_DAY);
                    }
                }
            }
        }
        return rulePassed;
    }

    private boolean validateDay(Integer day, String key) {
        boolean rulePassed = true;
        if (day != null && day.compareTo(31) > 0) {
            rulePassed = false;
            this.reportError(key, "error.committeeSchedule.day", "31");
        }
        return rulePassed;
    }

    private boolean validateDay(Integer day, String month, String key) {
        boolean rulePassed = true;
        int maxDay = StringUtils.equalsIgnoreCase((CharSequence)month, (CharSequence)"FEBRUARY") ? 29 : (StringUtils.equalsIgnoreCase((CharSequence)month, (CharSequence)"APRIL") || StringUtils.equalsIgnoreCase((CharSequence)month, (CharSequence)"JUNE") || StringUtils.equalsIgnoreCase((CharSequence)month, (CharSequence)"SEPTEMBER") || StringUtils.equalsIgnoreCase((CharSequence)month, (CharSequence)"NOVEMBER") ? 30 : 31);
        if (day != null && day.compareTo(maxDay) > 0) {
            rulePassed = false;
            this.reportError(key, "error.committeeSchedule.day", "31");
        }
        return rulePassed;
    }
}

