/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.modifysubmission;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.actions.IacucProtocolActionBean;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewerBean;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.springframework.util.AutoPopulatingList;

public class IacucProtocolModifySubmissionBean
extends IacucProtocolActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String submissionTypeCode = "";
    private String protocolReviewTypeCode = "";
    private String submissionQualifierTypeCode = "";
    private boolean billable;
    private String committeeId = null;
    private String scheduleId = null;
    private List<ProtocolReviewerBeanBase> reviewers = new AutoPopulatingList(IacucProtocolReviewerBean.class);
    private Date dueDate;
    private int numberOfReviewers = 0;
    private int checkListItemDescriptionIndex = 0;
    private String selectedProtocolReviewTypeCode = null;

    public IacucProtocolModifySubmissionBean(ActionHelperBase actionHelper) {
        super(actionHelper);
        this.submissionTypeCode = actionHelper.getProtocol().getProtocolSubmission().getProtocolSubmissionType().getSubmissionTypeCode();
        this.submissionQualifierTypeCode = actionHelper.getProtocol().getProtocolSubmission().getSubmissionTypeQualifierCode();
        this.protocolReviewTypeCode = actionHelper.getProtocol().getProtocolSubmission().getProtocolReviewTypeCode();
        this.billable = actionHelper.getProtocol().getProtocolSubmission().isBillable();
        this.committeeId = actionHelper.getProtocol().getProtocolSubmission().getCommitteeId();
        this.scheduleId = actionHelper.getProtocol().getProtocolSubmission().getScheduleId();
    }

    public void setNumberOfReviewers(int numberOfReviewers) {
        this.numberOfReviewers = numberOfReviewers;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public void prepareView() {
        IacucProtocolForm iacucProtocolForm;
        ProtocolSubmissionBase submission = this.getProtocol().getProtocolSubmission();
        if (submission != null && (iacucProtocolForm = (IacucProtocolForm)this.getActionHelper().getProtocolForm()).isReinitializeModifySubmissionFields()) {
            iacucProtocolForm.setReinitializeModifySubmissionFields(false);
            this.reviewers.clear();
            this.submissionTypeCode = submission.getSubmissionTypeCode();
            this.protocolReviewTypeCode = submission.getProtocolReviewTypeCode();
            this.submissionQualifierTypeCode = submission.getSubmissionTypeQualifierCode();
            this.billable = submission.isBillable();
            this.committeeId = submission.getCommitteeId();
            this.scheduleId = submission.getScheduleId();
            if (!(StringUtils.isBlank((CharSequence)this.committeeId) || StringUtils.isBlank((CharSequence)this.scheduleId) && this.isFullCommmitteeReview(submission))) {
                this.populateReviewers(this.committeeId, this.scheduleId, submission);
            }
        }
    }

    private boolean isFullCommmitteeReview(ProtocolSubmissionBase submission) {
        return submission != null && "3".equals(submission.getProtocolReviewTypeCode());
    }

    private void populateReviewers(String committeeId, String scheduleId, ProtocolSubmissionBase submission) {
        List<CommitteeMembershipBase> members = this.getProtocol().filterOutProtocolPersonnel(this.getCommitteeService().getAvailableMembers(committeeId, scheduleId));
        for (CommitteeMembershipBase member : members) {
            this.reviewers.add(new IacucProtocolReviewerBean(member));
        }
        block1: for (ProtocolOnlineReviewBase review : submission.getProtocolOnlineReviews()) {
            if (!review.isActive()) continue;
            for (ProtocolReviewerBeanBase reviewerBean : this.reviewers) {
                if (!reviewerBean.isProtocolReviewerBeanForReviewer(review.getProtocolReviewer())) continue;
                reviewerBean.setReviewerTypeCode(review.getProtocolReviewer().getReviewerTypeCode());
                continue block1;
            }
        }
    }

    public void setReviewers(List<ProtocolReviewerBeanBase> reviewers) {
        this.reviewers = reviewers;
    }

    public String getCommitteeId() {
        return this.committeeId;
    }

    public void setCommitteeId(String committeeId) {
        this.committeeId = committeeId;
    }

    public String getCurrentScheduleId() {
        return this.scheduleId;
    }

    public void setCurrentScheduleId(String currentScheduleId) {
        this.scheduleId = currentScheduleId;
    }

    public List<ProtocolReviewerBeanBase> getReviewers() {
        return this.reviewers;
    }

    public ProtocolReviewerBeanBase getReviewer(int i) {
        return this.reviewers.get(i);
    }

    public List<ProtocolReviewerBeanBase> getLeftReviewers() {
        ArrayList<ProtocolReviewerBeanBase> leftReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = 0; i < (this.reviewers.size() + 1) / 2; ++i) {
            leftReviewers.add(this.reviewers.get(i));
        }
        return leftReviewers;
    }

    public List<ProtocolReviewerBeanBase> getRightReviewers() {
        ArrayList<ProtocolReviewerBeanBase> rightReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = (this.reviewers.size() + 1) / 2; i < this.reviewers.size(); ++i) {
            rightReviewers.add(this.reviewers.get(i));
        }
        return rightReviewers;
    }

    public String getSubmissionTypeCode() {
        return this.submissionTypeCode;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setSubmissionTypeCode(String submissionTypeCode) {
        this.submissionTypeCode = submissionTypeCode;
    }

    public String getProtocolReviewTypeCode() {
        return this.protocolReviewTypeCode;
    }

    public void setProtocolReviewTypeCode(String protocolReviewTypeCode) {
        this.protocolReviewTypeCode = protocolReviewTypeCode;
    }

    public String getSubmissionQualifierTypeCode() {
        return this.submissionQualifierTypeCode;
    }

    public void setSubmissionQualifierTypeCode(String submissionQualifierTypeCode) {
        this.submissionQualifierTypeCode = submissionQualifierTypeCode;
    }

    public boolean isBillable() {
        return this.billable;
    }

    public void setBillable(boolean billable) {
        this.billable = billable;
    }

    public void setCheckListItemDescriptionInfo(String protocolReviewTypeCode, int index) {
        this.selectedProtocolReviewTypeCode = protocolReviewTypeCode;
        this.checkListItemDescriptionIndex = index;
    }

    private CommitteeServiceBase getCommitteeService() {
        return KcServiceLocator.getService(IacucCommitteeService.class);
    }
}

