/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitEvent;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ProtocolUnitEventBase
extends KcDocumentEventBase
implements ProtocolUnitEvent {
    private static final Logger LOG = LogManager.getLogger(ProtocolUnitEventBase.class);
    private ProtocolUnitBase protocolUnit;
    private int personIndex;

    protected ProtocolUnitEventBase(String description, String errorPathPrefix, ProtocolDocumentBase document, ProtocolUnitBase protocolUnit, int personIndex) {
        super(description, errorPathPrefix, (Document)document);
        this.setProtocolUnit(protocolUnit);
        this.personIndex = personIndex;
        this.logEvent();
    }

    @Override
    public ProtocolUnitBase getProtocolUnit() {
        return this.protocolUnit;
    }

    @Override
    public int getPersonIndex() {
        return this.personIndex;
    }

    private void setProtocolUnit(ProtocolUnitBase protocolUnit) {
        this.protocolUnit = (ProtocolUnitBase)ObjectUtils.deepCopy((Serializable)protocolUnit);
    }

    @Override
    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.getProtocolUnit() == null) {
            logMessage.append("null protocolUnit");
        } else {
            logMessage.append(this.getProtocolUnit().toString());
        }
        LOG.debug((CharSequence)logMessage);
    }
}

