/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.nih;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.kuali.coeus.propdev.impl.s2s.nih.PageSectionService;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="pageSectionService")
public class PageSectionServiceImpl
implements PageSectionService {
    public static final String PARENT_BEAN = "parentBean";
    @Autowired
    @Qualifier(value="dataDictionaryService")
    private DataDictionaryService dataDictionaryService;
    private static Map<String, ArrayList<String>> pageToSections = new HashMap<String, ArrayList<String>>();

    @Override
    public List<String> getSectionsOnPage(String pageId) {
        return this.getSectionIds(pageId);
    }

    private List<String> getSectionIds(String pageId) {
        DataDictionary dd = this.dataDictionaryService.getDataDictionary();
        List<String> nm = this.getBeanNamesForNamespace(dd);
        List<String> sectionIds = nm.stream().filter(currentName -> this.getSectionIds(dd, (String)currentName, pageId)).collect(Collectors.toList());
        return sectionIds;
    }

    protected boolean getSectionIds(DataDictionary dd, String currentName, String pageId) {
        Pattern p = Pattern.compile("Actions|Button|Dialog|parentBean|Confirm|Footer|LowerGroup|Wizard");
        Matcher m = p.matcher(currentName);
        try {
            Object bean;
            if ((currentName.contains(pageId) || pageToSections.containsKey(pageId) && pageToSections.get(pageId).contains(currentName)) && !m.find() && !((bean = dd.getDictionaryBean(currentName)) instanceof PageGroup) && bean instanceof Group && ((Container)bean).getLayoutManager() != null) {
                return true;
            }
        }
        catch (BeanIsAbstractException beanIsAbstractException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List<String> getPageIds() {
        DataDictionary dd = this.dataDictionaryService.getDataDictionary();
        List<String> nm = this.getBeanNamesForNamespace(dd);
        List<String> pageIds = nm.stream().filter(currentName -> this.filterBeansForPages(dd, (String)currentName)).sorted().collect(Collectors.toList());
        return pageIds;
    }

    protected boolean filterBeansForPages(DataDictionary dd, String currentName) {
        try {
            Object bean;
            if (!currentName.contains(PARENT_BEAN) && (bean = dd.getDictionaryBean(currentName)) instanceof PageGroup && ((Container)bean).getLayoutManager() != null) {
                return true;
            }
        }
        catch (BeanIsAbstractException beanIsAbstractException) {
            // empty catch block
        }
        return false;
    }

    public List<String> getBeanNamesForNamespace(DataDictionary dd) {
        return dd.getBeanNamesForNamespace("KC-PD");
    }

    static {
        ArrayList<String> sections = new ArrayList<String>();
        sections.add("PropDev-OpportunityPage-Forms");
        pageToSections.put("PropDev-SponsorProgramInfoPage", sections);
        sections = new ArrayList();
        sections.add("PropDev-ApplicantOrganizationPage-Section");
        sections.add("PropDev-PerformingOrganizationPage-Section");
        sections.add("PropDev-PerformanceSitesPage-Section");
        sections.add("PropDev-OtherOrganizationsPage-Section");
        pageToSections.put("PropDev-OrganizationLocationsPage", sections);
        sections = new ArrayList();
        sections.add("PropDev-CreditAllocation-Section");
        pageToSections.put("PropDev-CreditAllocationPage", sections);
        sections = new ArrayList();
        sections.add("PropDev-Supplemental-Section");
        pageToSections.put("PropDev-SupplementalPage", sections);
    }
}

