/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.propdev.impl.abstrct.ProposalAbstract;
import org.kuali.coeus.propdev.impl.attachment.AddNarrativeEvent;
import org.kuali.coeus.propdev.impl.attachment.LegacyNarrativeService;
import org.kuali.coeus.propdev.impl.attachment.MultipartFileValidationService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeType;
import org.kuali.coeus.propdev.impl.attachment.NarrativeUserRights;
import org.kuali.coeus.propdev.impl.attachment.NewNarrativeUserRightsEvent;
import org.kuali.coeus.propdev.impl.attachment.ProposalDevelopmentAttachment;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotification;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.propdev.impl.person.attachment.AddPersonnelAttachmentEvent;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.file.FileMeta;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.GrowlMessage;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.FileControllerService;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentAttachmentController
extends ProposalDevelopmentControllerBase {
    private static final String ATTACHMENT_FILE = "multipartFile";
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="legacyNarrativeService")
    private LegacyNarrativeService legacyNarrativeService;
    @Autowired
    @Qualifier(value="kcFileControllerService")
    private FileControllerService kcFileControllerService;
    @Autowired
    @Qualifier(value="multipartFileValidationService")
    private MultipartFileValidationService multipartFileValidationService;
    @Autowired
    @Qualifier(value="fileControllerService")
    private FileControllerService fileControllerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addFileUploadLine"})
    public ModelAndView addFileUploadLine(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, MultipartHttpServletRequest request) {
        String selectedCollectionPath = request.getParameter("bindingPath");
        this.addEditableCollectionLine(form, selectedCollectionPath);
        MessageMap messages = new MessageMap();
        request.getFileNames().forEachRemaining(name -> messages.merge(this.multipartFileValidationService.validateMultipartFile(ATTACHMENT_FILE, request.getFile(name))));
        if (!messages.hasMessages()) {
            Object object = ObjectPropertyUtils.getPropertyValue((Object)form, (String)selectedCollectionPath);
            synchronized (object) {
                return this.getFileControllerService().addFileUploadLine((UifFormBase)form);
            }
        }
        this.getGlobalVariableService().getMessageMap().merge(messages);
        this.doErrorMessageWorkaround(messages);
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        form.setAjaxRequest(true);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    protected void doErrorMessageWorkaround(MessageMap messages) {
        messages.getAllPropertiesWithErrors().stream().flatMap(prop -> messages.getMessages(prop).stream()).forEach(message -> {
            GrowlMessage growl = new GrowlMessage();
            growl.setMessageKey(message.getErrorKey());
            growl.setMessageParameters(message.getMessageParameters());
            growl.setComponentCode(message.getComponentCode());
            growl.setNamespaceCode(message.getNamespaceCode());
            growl.setTitle("Error");
            this.getGlobalVariableService().getMessageMap().addGrowlMessage(growl);
        });
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=deleteFileUploadLine"})
    public ModelAndView deleteFileUploadLine(@ModelAttribute(value="KualiForm") UifFormBase uifForm) {
        return this.getFileControllerService().deleteFileUploadLine(uifForm);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=getFileFromLine"})
    public void getFileFromLine(@ModelAttribute(value="KualiForm") UifFormBase uifForm, HttpServletResponse response) {
        this.getKcFileControllerService().getFileFromLine(uifForm, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=markAllProposalAttachments"})
    public ModelAndView markAllProposalAttachments(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return this.markAllAttachmentStatus(form, form.getProposalDevelopmentAttachmentHelper().getProposalAttachmentModuleStatusCode());
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=markAllInternalAttachments"})
    public ModelAndView markAllInternalAttachments(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return this.markAllAttachmentStatus(form, form.getProposalDevelopmentAttachmentHelper().getInternalAttachmentModuleStatusCode());
    }

    protected ModelAndView markAllAttachmentStatus(ProposalDevelopmentDocumentForm form, String moduleStatusCode) {
        String collectionPath = form.getActionParamaterValue("selectedCollectionPath");
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)collectionPath);
        collection.stream().filter(object -> object instanceof Narrative).map(object -> (Narrative)object).forEach(narrative -> {
            narrative.setModuleStatusCode(moduleStatusCode);
            this.getDataObjectService().wrap(narrative).fetchRelationship("narrativeStatus");
        });
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareNarrative"})
    public ModelAndView prepareNarrative(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        form.getProposalDevelopmentAttachmentHelper().reset();
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            Narrative tmpNarrative = new Narrative();
            form.getProposalDevelopmentAttachmentHelper().setSelectedLineIndex(selectedLine);
            PropertyUtils.copyProperties((Object)tmpNarrative, (Object)form.getDevelopmentProposal().getNarrative(Integer.parseInt(selectedLine)));
            form.getProposalDevelopmentAttachmentHelper().setNarrative(tmpNarrative);
        }
        return this.getModelAndViewService().showDialog("PropDev-AttachmentsPage-ProposalDetails", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareBiography"})
    public ModelAndView prepareBiography(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        form.getProposalDevelopmentAttachmentHelper().reset();
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            ProposalPersonBiography tmpBiography = new ProposalPersonBiography();
            form.getProposalDevelopmentAttachmentHelper().setSelectedLineIndex(selectedLine);
            PropertyUtils.copyProperties((Object)tmpBiography, (Object)form.getDevelopmentProposal().getPropPersonBio(Integer.parseInt(selectedLine)));
            form.getProposalDevelopmentAttachmentHelper().setBiography(tmpBiography);
        }
        return this.getModelAndViewService().showDialog("PropDev-AttachmentsPage-PersonnelDetails", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareAbstract"})
    public ModelAndView prepareAbstract(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        form.getProposalDevelopmentAttachmentHelper().reset();
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            ProposalAbstract tmpAbstract = new ProposalAbstract();
            form.getProposalDevelopmentAttachmentHelper().setSelectedLineIndex(selectedLine);
            PropertyUtils.copyProperties((Object)tmpAbstract, (Object)form.getDevelopmentProposal().getProposalAbstract(Integer.parseInt(selectedLine)));
            form.getProposalDevelopmentAttachmentHelper().setProposalAbstract(tmpAbstract);
        }
        return this.getModelAndViewService().showDialog("PropDev-AttachmentsPage-AbstractDetails", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareInstituteAttachment"})
    public ModelAndView prepareInstituteAttachment(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        form.getProposalDevelopmentAttachmentHelper().reset();
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            Narrative tmpNarrative = new Narrative();
            form.getProposalDevelopmentAttachmentHelper().setSelectedLineIndex(selectedLine);
            PropertyUtils.copyProperties((Object)tmpNarrative, (Object)form.getDevelopmentProposal().getInstituteAttachment(Integer.parseInt(selectedLine)));
            form.getProposalDevelopmentAttachmentHelper().setInstituteAttachment(tmpNarrative);
        }
        return this.getModelAndViewService().showDialog("PropDev-AttachmentsPage-InternalDetails", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareNote"})
    public ModelAndView prepareNote(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        form.getProposalDevelopmentAttachmentHelper().reset();
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            Note tmpNote = new Note();
            form.getProposalDevelopmentAttachmentHelper().setSelectedLineIndex(selectedLine);
            PropertyUtils.copyProperties((Object)tmpNote, (Object)form.getProposalDevelopmentDocument().getNote(Integer.parseInt(selectedLine)));
            form.getProposalDevelopmentAttachmentHelper().setNote(tmpNote);
        }
        return this.getModelAndViewService().showDialog("PropDev-AttachmentsPage-NoteDetails", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addNarrative"})
    public ModelAndView addNarrative(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        Narrative narrative = form.getProposalDevelopmentAttachmentHelper().getNarrative();
        this.initializeNarrative(narrative, form);
        if (this.getKualiRuleService().applyRules((DocumentEvent)new AddNarrativeEvent("proposalDevelopmentAttachmentHelper.narrative", form.getProposalDevelopmentDocument(), form.getProposalDevelopmentAttachmentHelper().getNarrative()))) {
            form.getDevelopmentProposal().getNarratives().add(0, narrative);
            form.getProposalDevelopmentAttachmentHelper().reset();
        } else {
            form.setUpdateComponentId("PropDev-AttachmentsPage-ProposalDetails");
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=checkForExistingNarratives"})
    public ModelAndView checkForExistingNarratives(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam String currentValue, @RequestParam(required=false) String previousValue, @RequestParam String propertyPath) {
        if (form.getDevelopmentProposal().isChild()) {
            NarrativeType narrativeType = (NarrativeType)this.getDataObjectService().find(NarrativeType.class, (Object)currentValue);
            DevelopmentProposal parentProposal = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)form.getDevelopmentProposal().getHierarchyParentProposalNumber());
            if (!narrativeType.isAllowMultiple() && this.getLegacyNarrativeService().doesProposalHaveNarrativeType(parentProposal, narrativeType)) {
                form.getProposalDevelopmentAttachmentHelper().setCurrentNarrativeTypeDescription(narrativeType.getDescription());
                form.getProposalDevelopmentAttachmentHelper().setPreviousNarrativeTypeValue(previousValue);
                form.getProposalDevelopmentAttachmentHelper().setNarrativeTypePropertyPath(propertyPath);
                return this.getModelAndViewService().showDialog("PropDev-AttachmentPage-ConfirmAddAttachmentToChild", true, (UifFormBase)form);
            }
        }
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=revertToPreviousNarrativeType"})
    public ModelAndView revertToPreviousNarrativeType(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        String propertyPath = form.getProposalDevelopmentAttachmentHelper().getNarrativeTypePropertyPath();
        String previousNarrativeTypeValue = form.getProposalDevelopmentAttachmentHelper().getPreviousNarrativeTypeValue();
        ObjectPropertyUtils.setPropertyValue((Object)form, (String)propertyPath, (Object)previousNarrativeTypeValue);
        if (StringUtils.startsWith((CharSequence)propertyPath, (CharSequence)"proposalDevelopmentAttachmentHelper")) {
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
            form.setUpdateComponentId("PropDev-AttachmentsPage-ProposalDetails");
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected void initializeNarrative(Narrative narrative, ProposalDevelopmentDocumentForm form) throws Exception {
        this.getLegacyNarrativeService().prepareNarrative(form.getProposalDevelopmentDocument(), narrative);
        MultipartFile file = narrative.getMultipartFile();
        if (narrative.getModuleStatusCode().equals("C") && narrative.getNarrativeAttachment() == null || file != null) {
            MessageMap messages = this.multipartFileValidationService.validateMultipartFile(ATTACHMENT_FILE, narrative.getMultipartFile());
            if (!messages.hasMessages()) {
                narrative.init(narrative.getMultipartFile());
                ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).updateAttachmentInformation(narrative.getNarrativeAttachment());
            } else {
                this.getGlobalVariableService().getMessageMap().merge(messages);
            }
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addInstituteAttachment"})
    public ModelAndView addInstituteAttachment(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        Narrative narrative = form.getProposalDevelopmentAttachmentHelper().getInstituteAttachment();
        this.initializeNarrative(narrative, form);
        form.getDevelopmentProposal().getInstituteAttachments().add(0, narrative);
        form.getProposalDevelopmentAttachmentHelper().reset();
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addBiography"})
    public ModelAndView addBiography(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        ProposalPersonBiography biography = form.getProposalDevelopmentAttachmentHelper().getBiography();
        biography.setDevelopmentProposal(document.getDevelopmentProposal());
        biography.setBiographyNumber(document.getDocumentNextValue("proposalDevelopment.proposalPersonBiography.biographyNumber"));
        biography.setUpdateUser(this.getGlobalVariableService().getUserSession().getPrincipalName());
        biography.setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
        this.getDataObjectService().wrap((Object)biography).fetchRelationship("propPerDocType");
        String errorPath = "proposalDevelopmentAttachmentHelper.biography.multipartFile";
        MessageMap messages = this.multipartFileValidationService.validateMultipartFile(errorPath, biography.getMultipartFile());
        boolean rulePassed = true;
        if (!messages.hasMessages()) {
            biography.init(biography.getMultipartFile());
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).updateAttachmentInformation(biography.getPersonnelAttachment());
            if (this.getKualiRuleService().applyRules((DocumentEvent)new AddPersonnelAttachmentEvent("proposalDevelopmentAttachmentHelper.biography", document, biography))) {
                form.getDevelopmentProposal().getPropPersonBios().add(0, biography);
                form.getProposalDevelopmentAttachmentHelper().reset();
            } else {
                rulePassed = false;
            }
        } else {
            this.getGlobalVariableService().getMessageMap().merge(messages);
            rulePassed = false;
        }
        if (!rulePassed) {
            form.setUpdateComponentId("PropDev-AttachmentsPage-PersonnelDetails");
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveNarrative"})
    public ModelAndView saveNarrative(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        Narrative narrative = form.getProposalDevelopmentAttachmentHelper().getNarrative();
        int selectedLineIndex = Integer.parseInt(form.getProposalDevelopmentAttachmentHelper().getSelectedLineIndex());
        narrative.refreshReferenceObject("narrativeType");
        narrative.refreshReferenceObject("narrativeStatus");
        if (this.isAttachmentFileChanged(narrative.getMultipartFile())) {
            narrative.init(narrative.getMultipartFile());
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).updateAttachmentInformation(narrative.getNarrativeAttachment());
        }
        if (this.getKualiRuleService().applyRules((DocumentEvent)new AddNarrativeEvent("proposalDevelopmentAttachmentHelper.narrative", form.getProposalDevelopmentDocument(), form.getProposalDevelopmentAttachmentHelper().getNarrative()))) {
            form.getDevelopmentProposal().getNarratives().set(selectedLineIndex, narrative);
            form.getProposalDevelopmentAttachmentHelper().reset();
        } else {
            form.setUpdateComponentId("PropDev-AttachmentsPage-ProposalDetails");
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        }
        if (form.getProposalDevelopmentDocument().getDocumentHeader().getWorkflowDocument().isEnroute()) {
            ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(form.getProposalDevelopmentDocument().getDevelopmentProposal(), "102", "Proposal Data Override");
            context.getRenderer().setModifiedNarrative(narrative);
            context.getRenderer().setDevelopmentProposal(form.getProposalDevelopmentDocument().getDevelopmentProposal());
            if (form.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                form.getNotificationHelper().initializeDefaultValues(context);
                form.setSendNarrativeChangeNotification(true);
            } else {
                this.getKcNotificationService().sendNotificationAndPersist(context, new ProposalDevelopmentNotification(), form.getDevelopmentProposal());
            }
        }
        return super.save(form);
    }

    protected boolean isAttachmentFileChanged(MultipartFile multipartFile) {
        MessageMap messages;
        boolean fileChanged;
        boolean bl = fileChanged = multipartFile != null;
        if (fileChanged && (messages = this.multipartFileValidationService.validateMultipartFile(ATTACHMENT_FILE, multipartFile)).hasMessages()) {
            this.getGlobalVariableService().getMessageMap().merge(messages);
        }
        return fileChanged;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=sendNarrativeChangeNotification"})
    public ModelAndView sendNarrativeChangeNotification(ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm) {
        if (proposalDevelopmentDocumentForm.isSendNarrativeChangeNotification()) {
            String step = proposalDevelopmentDocumentForm.getNotificationHelper().getNotificationRecipients().isEmpty() ? "0" : "2";
            proposalDevelopmentDocumentForm.getActionParameters().put("Kc-SendNotification-Wizard.step", step);
            return this.getModelAndViewService().showDialog("Kc-SendNotification-Wizard", true, (UifFormBase)proposalDevelopmentDocumentForm);
        }
        proposalDevelopmentDocumentForm.setSendNarrativeChangeNotification(false);
        return this.getModelAndViewService().getModelAndView((UifFormBase)proposalDevelopmentDocumentForm);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveBiography"})
    public ModelAndView saveBiography(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        ProposalPersonBiography biography = form.getProposalDevelopmentAttachmentHelper().getBiography();
        int selectedLineIndex = Integer.parseInt(form.getProposalDevelopmentAttachmentHelper().getSelectedLineIndex());
        biography.setUpdateUser(this.getGlobalVariableService().getUserSession().getPrincipalName());
        biography.setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
        this.getDataObjectService().wrap((Object)biography).fetchRelationship("propPerDocType");
        if (this.isAttachmentFileChanged(biography.getMultipartFile())) {
            biography.init(biography.getMultipartFile());
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).updateAttachmentInformation(biography.getPersonnelAttachment());
        }
        if (this.getKualiRuleService().applyRules((DocumentEvent)new AddPersonnelAttachmentEvent("proposalDevelopmentAttachmentHelper.biography", form.getProposalDevelopmentDocument(), biography))) {
            form.getDevelopmentProposal().getPropPersonBios().set(selectedLineIndex, biography);
            form.getProposalDevelopmentAttachmentHelper().reset();
        } else {
            form.setUpdateComponentId("PropDev-AttachmentsPage-PersonnelDetails");
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        }
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveInstituteAttachment"})
    public ModelAndView saveInstituteAttachment(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        Narrative narrative = form.getProposalDevelopmentAttachmentHelper().getInstituteAttachment();
        int selectedLineIndex = Integer.parseInt(form.getProposalDevelopmentAttachmentHelper().getSelectedLineIndex());
        this.getDataObjectService().wrap((Object)narrative).fetchRelationship("narrativeType");
        MessageMap messages = this.multipartFileValidationService.validateMultipartFile(ATTACHMENT_FILE, narrative.getMultipartFile());
        if (!messages.hasMessages()) {
            narrative.init(narrative.getMultipartFile());
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).updateAttachmentInformation(narrative.getNarrativeAttachment());
            form.getDevelopmentProposal().getInstituteAttachments().set(selectedLineIndex, narrative);
            form.getProposalDevelopmentAttachmentHelper().reset();
        } else {
            this.getGlobalVariableService().getMessageMap().merge(messages);
        }
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveAbstract"})
    public ModelAndView saveAbstract(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ProposalAbstract proposalAbstract = form.getProposalDevelopmentAttachmentHelper().getProposalAbstract();
        int selectedLineIndex = Integer.parseInt(form.getProposalDevelopmentAttachmentHelper().getSelectedLineIndex());
        form.getDevelopmentProposal().getProposalAbstracts().set(selectedLineIndex, proposalAbstract);
        form.getProposalDevelopmentAttachmentHelper().reset();
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveNote"})
    public ModelAndView saveNote(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        Note note = form.getProposalDevelopmentAttachmentHelper().getNote();
        int selectedLineIndex = Integer.parseInt(form.getProposalDevelopmentAttachmentHelper().getSelectedLineIndex());
        List<Note> notes = form.getProposalDevelopmentDocument().getNotes();
        notes.set(selectedLineIndex, note);
        form.getProposalDevelopmentAttachmentHelper().reset();
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=updateEditableFileAttachment"})
    public ModelAndView updateEditableFileAttachment(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        String collectionPath = form.getActionParamaterValue("selectedCollectionPath");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).toggleAttachmentFile(form, collectionPath, selectedLine);
        List attachments = (List)PropertyUtils.getNestedProperty((Object)form, (String)collectionPath);
        ((ProposalDevelopmentAttachment)attachments.get(Integer.parseInt(selectedLine))).setMultipartFile(null);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=updateEditableProposalFileAttachment"})
    public ModelAndView updateEditableProposalFileAttachment(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        String collectionPath = "document.developmentProposal.narratives";
        String selectedLine = form.getProposalDevelopmentAttachmentHelper().getSelectedLineIndex();
        ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).toggleAttachmentFile(form, "document.developmentProposal.narratives", form.getProposalDevelopmentAttachmentHelper().getSelectedLineIndex());
        List attachments = (List)PropertyUtils.getNestedProperty((Object)form, (String)collectionPath);
        ((ProposalDevelopmentAttachment)attachments.get(Integer.parseInt(selectedLine))).setMultipartFile(null);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addProposalAttachmentRights"})
    public ModelAndView addProposalAttachmentRights(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        int selectedLine = Integer.parseInt(form.getNarrativeUserRightsSelectedAttachment());
        boolean rulePassed = this.getKualiRuleService().applyRules((DocumentEvent)new NewNarrativeUserRightsEvent(form.getProposalDevelopmentDocument(), form.getNarrativeUserRights(), selectedLine));
        if (rulePassed) {
            form.getDevelopmentProposal().getNarrative(selectedLine).getNarrativeUserRights().clear();
            form.getDevelopmentProposal().getNarrative(selectedLine).getNarrativeUserRights().addAll(form.getNarrativeUserRights());
        }
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=getProposalAttachmentRights"})
    public ModelAndView getProposalAttachmentRights(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam(value="actionParameters[selectedLineIndex]") String selectedLine) throws Exception {
        form.getDevelopmentProposal().populateNarrativeRightsForLoggedinUser();
        form.getDevelopmentProposal().populatePersonNameForNarrativeUserRights(Integer.parseInt(selectedLine));
        Narrative selectedNarrative = form.getDevelopmentProposal().getNarratives().get(Integer.parseInt(selectedLine));
        ArrayList<NarrativeUserRights> editableRights = new ArrayList<NarrativeUserRights>();
        for (NarrativeUserRights right : selectedNarrative.getNarrativeUserRights()) {
            NarrativeUserRights editableRight = new NarrativeUserRights();
            PropertyUtils.copyProperties((Object)editableRight, (Object)right);
            editableRights.add(editableRight);
        }
        form.setNarrativeUserRights(editableRights);
        form.setNarrativeUserRightsSelectedAttachment(selectedLine);
        form.getActionParameters().put("attachmentType", "proposalAttachment");
        return this.getModelAndViewService().showDialog("PropDev-AttachmentPage-ViewEditRightDialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addInstituteAttachmentRights"})
    public ModelAndView addInstituteAttachmentRights(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        int selectedLine = Integer.parseInt(form.getNarrativeUserRightsSelectedAttachment());
        boolean rulePassed = this.getKualiRuleService().applyRules((DocumentEvent)new NewNarrativeUserRightsEvent(form.getProposalDevelopmentDocument(), form.getNarrativeUserRights(), selectedLine));
        if (rulePassed) {
            form.getDevelopmentProposal().getInstituteAttachment(selectedLine).getNarrativeUserRights().clear();
            form.getDevelopmentProposal().getInstituteAttachment(selectedLine).getNarrativeUserRights().addAll(form.getNarrativeUserRights());
        }
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=getInstituteAttachmentRights"})
    public ModelAndView getInstituteAttachmentRights(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam(value="actionParameters[selectedLineIndex]") String selectedLine) throws Exception {
        form.getDevelopmentProposal().populateNarrativeRightsForLoggedinUser();
        form.getDevelopmentProposal().populatePersonNameForInstituteAttachmentUserRights(Integer.parseInt(selectedLine));
        Narrative selectedNarrative = form.getDevelopmentProposal().getInstituteAttachment(Integer.parseInt(selectedLine));
        ArrayList<NarrativeUserRights> editableRights = new ArrayList<NarrativeUserRights>();
        for (NarrativeUserRights right : selectedNarrative.getNarrativeUserRights()) {
            NarrativeUserRights editableRight = new NarrativeUserRights();
            PropertyUtils.copyProperties((Object)editableRight, (Object)right);
            editableRights.add(editableRight);
        }
        form.setNarrativeUserRights(editableRights);
        form.setNarrativeUserRightsSelectedAttachment(selectedLine);
        form.getActionParameters().put("attachmentType", "instituteAttachment");
        return this.getModelAndViewService().showDialog("PropDev-AttachmentPage-ViewEditRightDialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=downloadAllNarratives"})
    public void downloadAllNarratives(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String collectionPath = form.getActionParamaterValue("selectedCollectionPath");
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)collectionPath);
        ArrayList<AttachmentDataSource> allAttachments = new ArrayList<AttachmentDataSource>();
        collection.stream().filter(object -> object instanceof KcFile).map(object -> (KcFile)object).forEachOrdered(attachment -> {
            PrintableAttachment newADS = new PrintableAttachment();
            newADS.setData(attachment.getData());
            if (attachment instanceof FileMeta) {
                newADS.setType(((FileMeta)attachment).getContentType());
            } else {
                newADS.setType(attachment.getType());
            }
            newADS.setName(attachment.getName());
            allAttachments.add(newADS);
        });
        new KcTransactionalDocumentActionBase();
        KcTransactionalDocumentActionBase.downloadAllAttachments(allAttachments, response, form.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalNumber() + "-Proposal_Attachments.zip");
    }

    public LegacyNarrativeService getLegacyNarrativeService() {
        return this.legacyNarrativeService;
    }

    public void setLegacyNarrativeService(LegacyNarrativeService legacyNarrativeService) {
        this.legacyNarrativeService = legacyNarrativeService;
    }

    public FileControllerService getKcFileControllerService() {
        return this.kcFileControllerService;
    }

    public void setKcFileControllerService(FileControllerService kcFileControllerService) {
        this.kcFileControllerService = kcFileControllerService;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public MultipartFileValidationService getMultipartFileValidationService() {
        return this.multipartFileValidationService;
    }

    public void setMultipartFileValidationService(MultipartFileValidationService multipartFileValidationService) {
        this.multipartFileValidationService = multipartFileValidationService;
    }

    public FileControllerService getFileControllerService() {
        return this.fileControllerService;
    }

    public void setFileControllerService(FileControllerService fileControllerService) {
        this.fileControllerService = fileControllerService;
    }
}

