/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.foreigntravel;

import java.io.Serializable;
import java.sql.Date;
import java.util.Collections;
import java.util.Map;
import org.kuali.coeus.common.framework.contact.Contactable;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardAssociate;
import org.kuali.kra.award.home.ValuableItem;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardApprovedForeignTravel
extends AwardAssociate
implements Comparable<AwardApprovedForeignTravel>,
ValuableItem {
    private static final long serialVersionUID = 1039155193608738040L;
    private Long approvedForeignTravelId;
    private KcPerson personTraveler;
    private String personId;
    private Integer rolodexId;
    private NonOrganizationalRolodex rolodexTraveler;
    private String travelerName;
    private String destination;
    private Date startDate;
    private Date endDate;
    private ScaleTwoDecimal amount;
    private static int instanceCount;
    private int instanceNumber;
    private transient KcPersonService kcPersonService;

    public AwardApprovedForeignTravel() {
        this.instanceNumber = instanceCount++;
    }

    public AwardApprovedForeignTravel(Object traveler, String destination, Date startDate, Date endDate, double amount) {
        if (traveler instanceof KcPerson) {
            this.setPersonTraveler((KcPerson)traveler);
        } else if (traveler instanceof NonOrganizationalRolodex) {
            this.setRolodexTraveler((NonOrganizationalRolodex)traveler);
        }
        this.destination = destination;
        this.startDate = startDate;
        this.endDate = endDate;
        this.amount = new ScaleTwoDecimal(amount);
    }

    AwardApprovedForeignTravel(AwardApprovedForeignTravel tripToCopy) {
        this.setPersonTraveler(tripToCopy.personTraveler);
        this.setApprovedForeignTravelId(null);
        this.setDestination(tripToCopy.destination);
        this.setStartDate(tripToCopy.startDate);
        this.setEndDate(tripToCopy.endDate);
        this.setAmount(tripToCopy.amount);
        this.setAward(tripToCopy.getAward());
    }

    public Long getApprovedForeignTravelId() {
        return this.approvedForeignTravelId;
    }

    public String getTravelerName() {
        return this.travelerName;
    }

    public KcPerson getPersonTraveler() {
        return this.personTraveler;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public Contactable getTraveler() {
        Contactable contact;
        Contactable contactable = this.personTraveler != null ? this.personTraveler : (contact = this.rolodexTraveler != null ? this.rolodexTraveler : null);
        if (contact == null) {
            contact = this.loadTraveler();
        }
        return contact;
    }

    public Serializable getContactId() {
        return this.personId != null ? this.personId : (this.rolodexId != null ? this.rolodexId : null);
    }

    public String getDestination() {
        return this.destination;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public NonOrganizationalRolodex getRolodexTraveler() {
        return this.rolodexTraveler;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public ScaleTwoDecimal getAmount() {
        return this.amount;
    }

    public boolean isEmployee() {
        return this.personId != null;
    }

    public boolean isNonemployee() {
        return this.rolodexId != null;
    }

    @Override
    public void resetPersistenceState() {
        this.approvedForeignTravelId = null;
    }

    public void setApprovedForeignTravelId(Long approvedForeignTravelId) {
        this.approvedForeignTravelId = approvedForeignTravelId;
    }

    public void setPersonTraveler(KcPerson personTraveler) {
        this.personTraveler = personTraveler;
        if (personTraveler != null) {
            this.travelerName = personTraveler.getFullName();
            this.personId = personTraveler.getPersonId();
            this.setRolodexTraveler(null);
        } else {
            this.personId = null;
            this.travelerName = this.rolodexTraveler != null ? this.rolodexTraveler.getFullName() : null;
        }
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public void setRolodexTraveler(NonOrganizationalRolodex rolodexTraveler) {
        this.rolodexTraveler = rolodexTraveler;
        if (rolodexTraveler != null) {
            this.travelerName = rolodexTraveler.getFullName();
            this.rolodexId = rolodexTraveler.getRolodexId();
            this.setPersonTraveler(null);
        } else {
            this.rolodexId = null;
            this.travelerName = this.personTraveler != null ? this.personTraveler.getFullName() : null;
        }
    }

    public void setTravelerName(String travelerName) {
        this.travelerName = travelerName;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setAmount(ScaleTwoDecimal amount) {
        this.amount = amount;
    }

    public void setAmount(double amount) {
        this.amount = new ScaleTwoDecimal(amount);
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = this.personTraveler == null ? 31 * result + (this.travelerName == null ? 0 : this.travelerName.hashCode()) : 31 * result + this.personTraveler.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwardApprovedForeignTravel)) {
            return false;
        }
        AwardApprovedForeignTravel other = (AwardApprovedForeignTravel)obj;
        if (this.destination == null ? other.destination != null : !this.destination.equals(other.destination)) {
            return false;
        }
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        if (this.personTraveler == null) {
            if (other.personTraveler != null) {
                return false;
            }
            return !(this.travelerName == null ? other.travelerName != null : !this.travelerName.equals(other.travelerName));
        }
        return other.personTraveler != null && this.personTraveler.getFullName().equalsIgnoreCase(other.personTraveler.getFullName());
    }

    @Override
    public String toString() {
        return String.format("********** %s=%s;%s=%s [%d]", "travelerId", this.personId, "travelerName", this.travelerName, this.instanceNumber);
    }

    @Override
    public int compareTo(AwardApprovedForeignTravel other) {
        int result;
        int n = result = this.startDate != null ? this.startDate.compareTo(other.startDate) : 0;
        if (result == 0) {
            Contactable thisTraveler = this.getTraveler();
            Contactable otherTraveler = other.getTraveler();
            if (thisTraveler != null && otherTraveler != null && (result = thisTraveler.getLastName().compareToIgnoreCase(otherTraveler.getLastName())) == 0) {
                result = thisTraveler.getFirstName().compareToIgnoreCase(otherTraveler.getFirstName());
            }
        }
        return result;
    }

    Contactable loadTraveler() {
        Contactable contact;
        if (this.personId != null) {
            contact = this.getKcPersonService().getKcPersonByPersonId(this.personId);
        } else if (this.rolodexId != null) {
            Map<String, Integer> map = Collections.singletonMap("rolodexId", this.rolodexId);
            contact = (Contactable)this.getBusinessObjectService().findMatching(NonOrganizationalRolodex.class, map).iterator().next();
        } else {
            contact = null;
        }
        return contact;
    }

    BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }
}

