/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.shipment;

import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.Search;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProjectRPSEntity;
import org.kuali.kra.excon.service.RPSRetrievalService;
import org.kuali.kra.excon.shipment.ExconIntlShipment;
import org.kuali.kra.excon.shipment.document.ExconIntlShipmentDocument;
import org.kuali.kra.excon.shipment.web.struts.form.ExconIntlShipmentForm;

public class ExconIntlShipmentBean
implements Serializable {
    private static final long serialVersionUID = 237567568457L;
    protected ExconIntlShipmentForm exconIntlShipmentForm;
    protected ExconIntlShipment exconIntlShipment;
    protected int currentResult = 0;
    private transient RPSRetrievalService rpsRetrievalService;

    public ExconIntlShipmentBean(ExconIntlShipmentForm exconIntlShipmentForm) {
        this.exconIntlShipmentForm = exconIntlShipmentForm;
        this.init();
    }

    public Search getRpsResultContentObject() {
        String rpsResult = this.getExconIntlShipment().getRpsResultContent();
        if (rpsResult != null) {
            return this.getRPSRetrievalService().getRpsResults(rpsResult);
        }
        return null;
    }

    public void performRPS() {
        ExconProjectRPSEntity rpsEntity = new ExconProjectRPSEntity();
        rpsEntity.setCompanyName(this.getExconIntlShipment().getReceivingParty());
        rpsEntity.setCountryCode(this.getExconIntlShipment().getCountryCode());
        String rpsResultXML = this.getRPSRetrievalService().retrieveRpsResults(rpsEntity);
        if (!StringUtils.isEmpty((CharSequence)rpsResultXML)) {
            this.getExconIntlShipment().setRpsResultContent(rpsResultXML);
        }
    }

    public int getNumMatches() {
        return this.getExconIntlShipment().getNumMatches();
    }

    public void setCurrentResult(int currentResult) {
        this.currentResult = currentResult;
    }

    public int getCurrentResult() {
        return this.currentResult;
    }

    protected void init() {
    }

    public ExconIntlShipment getExconIntlShipment() {
        return this.getDocument().getExconIntlShipment();
    }

    protected ExconIntlShipmentDocument getDocument() {
        return this.exconIntlShipmentForm.getExconIntlShipmentDocument();
    }

    protected RPSRetrievalService getRPSRetrievalService() {
        if (this.rpsRetrievalService == null) {
            this.rpsRetrievalService = KcServiceLocator.getService(RPSRetrievalService.class);
        }
        return this.rpsRetrievalService;
    }

    public void setRpsRetrievalService(RPSRetrievalService rpsRetrievalService) {
        this.rpsRetrievalService = rpsRetrievalService;
    }
}

