/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleQueryResults;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="systemAuthorizationService")
public class SystemAuthorizationServiceImpl
implements SystemAuthorizationService {
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="roleService")
    private RoleService roleManagementService;
    @Autowired
    @Qualifier(value="kimTypeInfoService")
    private KimTypeInfoService kimTypeInfoService;

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    protected KimTypeInfoService getKimTypeInfoService() {
        return this.kimTypeInfoService;
    }

    public void setKimTypeInfoService(KimTypeInfoService kimTypeInfoService) {
        this.kimTypeInfoService = kimTypeInfoService;
    }

    @Override
    public List<Role> getRolesForPermission(String permissionName, String namespaceCode) {
        List roleResults = this.permissionService.getRoleIdsForPermission(namespaceCode, permissionName);
        return this.roleManagementService.getRoles(roleResults);
    }

    @Override
    public List<String> getRoleNamesForPermission(String permissionName, String namespaceCode) {
        ArrayList<String> roleNames = new ArrayList<String>();
        List<Role> roles = this.getRolesForPermission(permissionName, namespaceCode);
        for (Role role : roles) {
            roleNames.add(role.getName());
        }
        return roleNames;
    }

    @Override
    public List<String> getRoleIdsForPermission(String permissionName, String namespaceCode) {
        ArrayList<String> roleNames = new ArrayList<String>();
        List<Role> roles = this.getRolesForPermission(permissionName, namespaceCode);
        for (Role role : roles) {
            roleNames.add(role.getId());
        }
        return roleNames;
    }

    @Override
    public boolean hasRole(String userId, String namespace, String roleName) {
        Role role = this.roleManagementService.getRoleByNamespaceCodeAndName(namespace, roleName);
        return role != null && this.roleManagementService.principalHasRole(userId, Collections.singletonList(role.getId()), null);
    }

    @Override
    public List<Role> getRoles(String namespaceCode) {
        QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)"namespaceCode", (Object)namespaceCode));
        predicates.add(PredicateFactory.equal((String)"active", (Object)Boolean.TRUE));
        queryBuilder.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[0]))});
        RoleQueryResults roleResults = this.roleManagementService.findRoles(queryBuilder.build());
        return roleResults.getResults();
    }

    @Override
    public KimType getKimTypeInfoForRole(Role role) {
        return this.getKimTypeInfoService().getKimType(role.getKimTypeId());
    }

    @Override
    public List<Role> getRolesByType(String roleNamespaceCode, String typeName, String typeNamespace) {
        List<Role> roles = this.getRoles(roleNamespaceCode);
        return this.filterByType(roles, typeName, typeNamespace);
    }

    protected List<Role> filterByType(List<Role> roles, String typeName, String typeNamespace) {
        ArrayList<Role> filtered = new ArrayList<Role>();
        for (Role r : roles) {
            KimType type = this.getKimTypeInfoForRole(r);
            if (!type.getNamespaceCode().equals(typeNamespace) || !type.getName().equals(typeName)) continue;
            filtered.add(r);
        }
        return filtered;
    }
}

