/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.rules.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.rules.AwardAddCfdaEvent;
import org.kuali.kra.award.home.rules.AwardCfdaRule;

public class AwardCfdaRuleImpl
implements AwardCfdaRule {
    private GlobalVariableService globalVariableService;

    @Override
    public boolean processAddCfdaRules(AwardAddCfdaEvent awardAddCfdaEvent) {
        AwardDocument awardDocument = (AwardDocument)awardAddCfdaEvent.getDocument();
        boolean valid = true;
        for (int i = 0; i < awardDocument.getAward().getAwardCfdas().size(); ++i) {
            String cfdaNumber = awardDocument.getAward().getAwardCfdas().get(i).getCfdaNumber();
            if (StringUtils.isBlank((CharSequence)cfdaNumber)) {
                this.getGlobalVariableService().getMessageMap().putError(String.format("document.awardList[0].awardCfdas[%s].cfdaNumber", i), "cfda.required", new String[0]);
                valid = false;
                continue;
            }
            if (this.isValidCfda(cfdaNumber) || this.getGlobalVariableService().getMessageMap().getMessages(String.format("document.developmentProposalList[0].proposalCfdas[%s].cfdaNumber", i)) != null) continue;
            this.getGlobalVariableService().getMessageMap().putWarning(String.format("document.awardList[0].awardCfdas[%s].cfdaNumber", i), "error.format.cfda", new String[]{cfdaNumber});
        }
        return valid;
    }

    public boolean isValidCfda(String cfdaNumber) {
        return cfdaNumber.matches("(\\d{2})(\\.)(\\d{3})[a-zA-z]?");
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }
}

