/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.sys.framework.keyvalue.KeyValueComparator;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProjectType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectTypeCodeValuesFinder
extends UifKeyValuesFinderBase {
    private static final long serialVersionUID = 82345259246485395L;
    private transient BusinessObjectService businessObjectService;
    private transient PermissionService permissionService;

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        Collection types = this.getBusinessObjectService().findAll(ExconProjectType.class);
        for (ExconProjectType type : types) {
            String projectTypeCode = type.getExconProjectTypeCode();
            HashMap<String, String> roleQualifiers = new HashMap<String, String>();
            roleQualifiers.put("projectTypeCode", projectTypeCode);
            if (!this.getPermissionService().isAuthorized(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "KC-EXCON", "Create Project Document", roleQualifiers)) continue;
            ConcreteKeyValue pair = new ConcreteKeyValue();
            pair.setKey(projectTypeCode);
            pair.setValue(type.getDescription());
            result.add((KeyValue)pair);
        }
        result.sort(new KeyValueComparator());
        return result;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

