/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.sys.impl.persistence;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.SchemaAnalyzer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.HttpUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.UserSession;

public class SchemaSpyFilter
implements Filter {
    private static final Logger LOG = LogManager.getLogger(SchemaSpyFilter.class);
    private static final String DB_TYPE_FLAG = "-t";
    private static final String MYSQL_DB_TYPE = "mysql";
    private static final String ORACLE_DB_TYPE = "ora";
    private static final String ORACLE_THIN_DB_TYPE = "orathin";
    private static final String DB_HOST_FLAG = "-host";
    private static final String DB_PORT_FLAG = "-port";
    private static final String DP_DRIVER_LOCATION_FLAG = "-dp";
    private static final String DB_NAME_FLAG = "-db";
    private static final String DB_USER_FLAG = "-u";
    private static final String DB_PASSWORD_FLAG = "-p";
    private static final String OUTPUT_DIR_FLAG = "-o";
    private static final String KIM_SCHEMA_SPY_VIEW_ID = "schemaspy";
    private static final String LOGLEVEL_FLAG = "-loglevel";
    private static final String FINEST_LEVEL = "finest";
    private static final String CONFIG_LEVEL = "config";
    private static final String INFO_LEVEL = "info";
    private static final String WARNING_LEVEL = "warning";
    private static final String SEVERE_LEVEL = "severe";
    private static final String REFRESH_PARAM = "refresh";
    private static final String REFRESH_TRUE = "true";
    private static final String LOW_QUALITY_FLAG = "-lq";
    private static final String FORMAT_FLAG = "-format";
    private static final String SVG_FORMAT = "svg";
    private static final String RENDERER_FLAG = "-renderer";
    private static final String NO_RENDERER = "";
    private static final String NO_LOGO = "-nologo";
    private static final String MYSQL_PLATFORM_NAME = "MySQL";
    private static final String ORACLE_PLATFORM_NAME = "Oracle";
    private static final String ORACLE_9I_PLATFORM_NAME = "Oracle9i";
    private static final String ORACLE_THIN_CON_STR_FRAGMENT = "oracle:thin";
    private static final String SCHEMA_XML = "_schema.xml";
    private static final String MYSQL_HOST = "HOST";
    private static final String MYSQL_PORT = "PORT";
    private static final String MYSQL_DBNAME = "DBNAME";
    private static final String ORACLE_DATABASE = "database";
    private static final String DB_SCHEMA_FLAG = "-s";
    private static final String MYSQL_SERVER_TIMEZONE = "serverTimezone";
    private FilterConfig filterConfig;
    private PermissionService permissionService;
    private GlobalVariableService globalVariableService;
    private SchemaAnalyzer schemaAnalyzer;
    private Config config;
    private boolean schemaSpyEnabled;
    private String datasourceUrl;
    private String dataSourceUsername;
    private String dataSourcePassword;
    private String dataSourcePlatform;
    private String datasourceDriverName;
    private String directoryName;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Runnable refreshSchemaSpy = () -> {
        if (this.isSchemaSpyEnabled()) {
            LOG.info("Refresh SchemaSpy Started");
            this.initialized.set(false);
            this.deleteSchemaSpyContent();
            this.config = this.createConfig();
            try {
                this.getSchemaAnalyzer().analyze(this.config);
            }
            catch (IOException | SQLException e) {
                throw new RuntimeException(e);
            }
            this.initialized.set(true);
            LOG.info("Refresh SchemaSpy Completed");
        }
    };

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.schemaAnalyzer = KcServiceLocator.getService(SchemaAnalyzer.class);
        this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        this.permissionService = KcServiceLocator.getService(PermissionService.class);
        ConfigurationService configurationService = (ConfigurationService)KcServiceLocator.getService("kualiConfigurationService");
        this.schemaSpyEnabled = configurationService.getPropertyValueAsBoolean("kc.schemaspy.enabled");
        this.datasourceUrl = configurationService.getPropertyValueAsString("datasource.url");
        this.dataSourceUsername = configurationService.getPropertyValueAsString("datasource.username");
        this.dataSourcePassword = configurationService.getPropertyValueAsString("datasource.password");
        this.dataSourcePlatform = configurationService.getPropertyValueAsString("datasource.ojb.platform");
        this.datasourceDriverName = configurationService.getPropertyValueAsString("datasource.driver.name");
        this.directoryName = KIM_SCHEMA_SPY_VIEW_ID;
        Executors.newSingleThreadExecutor().execute(this.refreshSchemaSpy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserSession session;
        UserSession userSession = session = this.getGlobalVariableService().getUserSession() != null ? this.getGlobalVariableService().getUserSession() : (UserSession)((HttpServletRequest)request).getSession().getAttribute("UserSession");
        if (session == null || !this.getPermissionService().isAuthorizedByTemplate(session.getPrincipalId(), "KR-KRAD", "Open View", Collections.singletonMap("viewId", KIM_SCHEMA_SPY_VIEW_ID), Collections.emptyMap())) {
            HttpUtils.disableCache((HttpServletResponse)response);
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        if (!this.isSchemaSpyEnabled()) {
            HttpUtils.disableCache((HttpServletResponse)response);
            response.getWriter().write("SchemaSpy has been disabled.");
            return;
        }
        AtomicBoolean atomicBoolean = this.initialized;
        synchronized (atomicBoolean) {
            if (REFRESH_TRUE.equals(request.getParameter(REFRESH_PARAM)) && this.initialized.get()) {
                Executors.newSingleThreadExecutor().execute(this.refreshSchemaSpy);
            }
            if (!this.initialized.get()) {
                HttpUtils.disableCache((HttpServletResponse)response);
                response.getWriter().write("Please wait. SchemaSpy is still processing.");
                return;
            }
        }
        if (this.requestingSchemaXml(((HttpServletRequest)request).getRequestURL())) {
            ((HttpServletResponse)response).sendRedirect(this.getSchemaXmlLocation(((HttpServletRequest)request).getRequestURL()));
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean requestingSchemaXml(StringBuffer url) {
        return url.indexOf(SCHEMA_XML) != -1;
    }

    private String getSchemaXmlLocation(StringBuffer url) {
        int index = url.indexOf(SCHEMA_XML);
        return url.replace(index, index + SCHEMA_XML.length(), this.config.getDb() + (String)(!this.isMySql() ? "." + this.config.getSchema() : NO_RENDERER) + ".xml").toString();
    }

    private Config createConfig() {
        String serverTimezone;
        List<DriverPropertyInfo> properties;
        try {
            Driver driver = DriverManager.getDriver(this.getDatasourceUrl());
            properties = Arrays.asList(driver.getPropertyInfo(this.getDatasourceUrl(), null));
            if (LOG.isInfoEnabled()) {
                LOG.info("Database Properties: \n" + properties.stream().map(p -> p.name + "=" + p.value).collect(Collectors.joining("\n")));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(DB_TYPE_FLAG);
        args.add(this.getDbType(this.getDatasourceUrl()));
        args.add(DB_HOST_FLAG);
        args.add(this.findHost(properties));
        args.add(DB_PORT_FLAG);
        args.add(this.findPort(properties));
        args.add(DP_DRIVER_LOCATION_FLAG);
        args.add(this.getDriverLocation());
        args.add(DB_NAME_FLAG);
        args.add(this.findDatabase(properties));
        if (!this.isMySql()) {
            args.add(DB_SCHEMA_FLAG);
            args.add(StringUtils.upperCase((String)this.getDataSourceUsername()));
        }
        args.add(DB_USER_FLAG);
        args.add(this.getDataSourceUsername());
        args.add(DB_PASSWORD_FLAG);
        args.add(this.getDataSourcePassword());
        args.add(OUTPUT_DIR_FLAG);
        args.add(this.getSchemaSpyPath().toString());
        args.add(LOGLEVEL_FLAG);
        if (LOG.isTraceEnabled()) {
            args.add(FINEST_LEVEL);
        } else if (LOG.isDebugEnabled()) {
            args.add(CONFIG_LEVEL);
        } else if (LOG.isInfoEnabled()) {
            args.add(INFO_LEVEL);
        } else if (LOG.isWarnEnabled()) {
            args.add(WARNING_LEVEL);
        } else {
            args.add(SEVERE_LEVEL);
        }
        args.add(LOW_QUALITY_FLAG);
        args.add(FORMAT_FLAG);
        args.add(SVG_FORMAT);
        args.add(RENDERER_FLAG);
        args.add(NO_RENDERER);
        args.add(NO_LOGO);
        Config cfg = new Config(args.toArray(new String[0]));
        if (this.isMySql() && StringUtils.isNotBlank((CharSequence)(serverTimezone = this.findTimezone(properties)))) {
            cfg.setConnectionProperties("serverTimezone\\=" + serverTimezone);
        }
        return cfg;
    }

    private boolean isMySql() {
        return MYSQL_PLATFORM_NAME.equals(this.getDataSourcePlatform());
    }

    private boolean isOracle(String url) {
        return ORACLE_PLATFORM_NAME.equals(this.getDataSourcePlatform()) || ORACLE_9I_PLATFORM_NAME.equals(this.getDataSourcePlatform()) && !url.contains(ORACLE_THIN_CON_STR_FRAGMENT);
    }

    private boolean isOracleThin(String url) {
        return ORACLE_PLATFORM_NAME.equals(this.getDataSourcePlatform()) || ORACLE_9I_PLATFORM_NAME.equals(this.getDataSourcePlatform()) && url.contains(ORACLE_THIN_CON_STR_FRAGMENT);
    }

    private String getDbType(String url) {
        if (this.isMySql()) {
            return MYSQL_DB_TYPE;
        }
        if (this.isOracleThin(url)) {
            return ORACLE_THIN_DB_TYPE;
        }
        if (this.isOracle(url)) {
            return ORACLE_DB_TYPE;
        }
        throw new RuntimeException("unknown db type");
    }

    private String getDriverLocation() {
        try {
            return Class.forName(this.getDatasourceDriverName()).getProtectionDomain().getCodeSource().getLocation().getPath();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String findHost(List<DriverPropertyInfo> properties) {
        return this.isMySql() ? (String)properties.stream().filter(p -> MYSQL_HOST.equalsIgnoreCase(p.name)).map(p -> p.value).findFirst().orElse(null) : (String)properties.stream().filter(p -> ORACLE_DATABASE.equalsIgnoreCase(p.name)).map(p -> p.value).map(p -> p.split(":")[0]).findFirst().orElse(null);
    }

    private String findPort(List<DriverPropertyInfo> properties) {
        return this.isMySql() ? (String)properties.stream().filter(p -> MYSQL_PORT.equalsIgnoreCase(p.name)).map(p -> p.value).findFirst().orElse(null) : (String)properties.stream().filter(p -> ORACLE_DATABASE.equalsIgnoreCase(p.name)).map(p -> p.value).map(p -> p.split(":")[1]).findFirst().orElse(null);
    }

    private String findTimezone(List<DriverPropertyInfo> properties) {
        return this.isMySql() ? (String)properties.stream().filter(p -> MYSQL_SERVER_TIMEZONE.equalsIgnoreCase(p.name)).map(p -> p.value).findFirst().orElse(null) : null;
    }

    private String findDatabase(List<DriverPropertyInfo> properties) {
        return this.isMySql() ? (String)properties.stream().filter(p -> MYSQL_DBNAME.equalsIgnoreCase(p.name)).map(p -> p.value).findFirst().orElse(null) : (String)properties.stream().filter(p -> ORACLE_DATABASE.equalsIgnoreCase(p.name)).map(p -> p.value).map(p -> p.split(":")[2]).findFirst().orElse(null);
    }

    private Path getSchemaSpyPath() {
        return Paths.get(this.filterConfig.getServletContext().getRealPath(File.separator), this.getDirectoryName());
    }

    private void deleteSchemaSpyContent() {
        if (Files.exists(this.getSchemaSpyPath(), new LinkOption[0])) {
            try {
                FileUtils.forceDelete((File)this.getSchemaSpyPath().toFile());
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void destroy() {
        this.deleteSchemaSpyContent();
        this.filterConfig = null;
        this.schemaAnalyzer = null;
        this.globalVariableService = null;
        this.permissionService = null;
        this.schemaSpyEnabled = false;
        this.datasourceUrl = null;
        this.dataSourceUsername = null;
        this.dataSourcePassword = null;
        this.dataSourcePlatform = null;
        this.datasourceDriverName = null;
        this.directoryName = null;
    }

    public SchemaAnalyzer getSchemaAnalyzer() {
        return this.schemaAnalyzer;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public void setSchemaAnalyzer(SchemaAnalyzer schemaAnalyzer) {
        this.schemaAnalyzer = schemaAnalyzer;
    }

    public boolean isSchemaSpyEnabled() {
        return this.schemaSpyEnabled;
    }

    public void setSchemaSpyEnabled(boolean schemaSpyEnabled) {
        this.schemaSpyEnabled = schemaSpyEnabled;
    }

    public String getDatasourceUrl() {
        return this.datasourceUrl;
    }

    public void setDatasourceUrl(String datasourceUrl) {
        this.datasourceUrl = datasourceUrl;
    }

    public String getDataSourceUsername() {
        return this.dataSourceUsername;
    }

    public void setDataSourceUsername(String dataSourceUsername) {
        this.dataSourceUsername = dataSourceUsername;
    }

    public String getDataSourcePassword() {
        return this.dataSourcePassword;
    }

    public void setDataSourcePassword(String dataSourcePassword) {
        this.dataSourcePassword = dataSourcePassword;
    }

    public String getDataSourcePlatform() {
        return this.dataSourcePlatform;
    }

    public void setDataSourcePlatform(String dataSourcePlatform) {
        this.dataSourcePlatform = dataSourcePlatform;
    }

    public String getDatasourceDriverName() {
        return this.datasourceDriverName;
    }

    public void setDatasourceDriverName(String datasourceDriverName) {
        this.datasourceDriverName = datasourceDriverName;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }
}

