/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.notification.impl.bo;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.notification.impl.bo.NotificationType;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class KcNotification
extends KcPersistableBusinessObjectBase {
    private static final long serialVersionUID = 8649080269418978865L;
    private Long notificationId;
    private Long notificationTypeId;
    private String documentNumber;
    private String recipients;
    private String subject;
    private String message;
    private Long owningDocumentIdFk;
    private NotificationType notificationType;
    private String createUser;
    private Timestamp createTimestamp;
    private transient BusinessObjectService businessObjectService;

    public Long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(Long notificationId) {
        this.notificationId = notificationId;
    }

    public Long getNotificationTypeId() {
        return this.notificationTypeId;
    }

    public void setNotificationTypeId(Long notificationTypeId) {
        this.notificationTypeId = notificationTypeId;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public NotificationType getNotificationType() {
        if (this.notificationType == null) {
            this.refreshReferenceObject("notificationType");
        }
        return this.notificationType;
    }

    public void setNotificationType(NotificationType notificationType) {
        this.notificationType = notificationType;
    }

    public Long getOwningDocumentIdFk() {
        return this.owningDocumentIdFk;
    }

    public void setOwningDocumentIdFk(Long owningDocumentIdFk) {
        this.owningDocumentIdFk = owningDocumentIdFk;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp != null ? this.createTimestamp : this.getUpdateTimestamp();
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getUpdateTimestampString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
        return this.getCreateTimestamp() == null ? "" : dateFormat.format(this.getCreateTimestamp());
    }

    public void persistOwningObject(KcPersistableBusinessObjectBase object) {
        this.getBusinessObjectService().save((PersistableBusinessObject)object);
    }

    public void resetPersistenceState() {
        this.setNotificationId(null);
        this.setOwningDocumentIdFk(null);
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        if (StringUtils.isEmpty((CharSequence)this.createUser)) {
            this.createUser = GlobalVariables.getUserSession().getPrincipalName();
            this.createTimestamp = KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp();
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }
}

