/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.docperm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.docperm.ProposalRoleService;
import org.kuali.coeus.propdev.impl.docperm.ProposalRoleTemplateService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalRoleTemplateService")
public class ProposalRoleTemplateServiceImpl
implements ProposalRoleTemplateService {
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kraAuthorizationService;
    @Autowired
    @Qualifier(value="roleService")
    private RoleService roleManagementService;
    @Autowired
    @Qualifier(value="proposalRoleService")
    private ProposalRoleService proposalRoleService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    public void setProposalRoleService(ProposalRoleService proposalRoleService) {
        this.proposalRoleService = proposalRoleService;
    }

    @Override
    public void addUsers(ProposalDevelopmentDocument doc) {
        String creatorUserId = this.getCreator(doc);
        HashMap<String, String> roleIdMap = new HashMap<String, String>();
        Role role = null;
        Collection<RoleMembership> proposalRoleTemplates = this.getRoleTemplates(doc.getDevelopmentProposal().getOwnedByUnitNumber());
        for (RoleMembership proposalRoleTemplate : proposalRoleTemplates) {
            String personId = proposalRoleTemplate.getMemberId();
            if (personId == null || StringUtils.equals((CharSequence)personId, (CharSequence)creatorUserId)) continue;
            if (StringUtils.isEmpty((CharSequence)((CharSequence)roleIdMap.get(proposalRoleTemplate.getRoleId())))) {
                role = this.roleManagementService.getRole(proposalRoleTemplate.getRoleId());
                roleIdMap.put(proposalRoleTemplate.getRoleId(), role.getName());
            }
            this.kraAuthorizationService.addDocumentLevelRole(personId, (String)roleIdMap.get(proposalRoleTemplate.getRoleId()), doc);
        }
    }

    protected String getCreator(ProposalDevelopmentDocument doc) {
        return this.globalVariableService.getUserSession().getPrincipalId();
    }

    protected Collection<RoleMembership> getRoleTemplates(String unitNumber) {
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", unitNumber);
        List<Role> proposalRoles = this.proposalRoleService.getRolesForDisplay();
        ArrayList<RoleMembership> membershipInfoList = new ArrayList<RoleMembership>();
        Collection memberIds = null;
        RoleMembership.Builder roleMembershipBuilder = null;
        for (Role role : proposalRoles) {
            memberIds = this.roleManagementService.getRoleMemberPrincipalIds(role.getNamespaceCode(), role.getName(), qualifiedRoleAttributes);
            if (!CollectionUtils.isNotEmpty((Collection)memberIds)) continue;
            for (String memberId : memberIds) {
                roleMembershipBuilder = RoleMembership.Builder.create((String)role.getId(), null, (String)memberId, (MemberType)MemberType.PRINCIPAL, null);
                membershipInfoList.add(roleMembershipBuilder.build());
            }
            roleMembershipBuilder = null;
            memberIds = null;
        }
        return membershipInfoList;
    }

    public KcAuthorizationService getKraAuthorizationService() {
        return this.kraAuthorizationService;
    }

    public RoleService getRoleManagementService() {
        return this.roleManagementService;
    }

    public ProposalRoleService getProposalRoleService() {
        return this.proposalRoleService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

