/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.question;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentS2sQuestionnaireAuditRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private transient ProposalDevelopmentS2sQuestionnaireService proposalDevelopmentS2sQuestionnaireService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        S2sOpportunity opp = developmentProposal.getS2sOpportunity();
        if (opp != null && opp.getS2sOppForms() != null) {
            List<AnswerHeader> headers = this.getProposalDevelopmentS2sQuestionnaireService().getProposalS2sAnswerHeaders(developmentProposal);
            for (AnswerHeader header : headers) {
                if (header.isCompleted()) continue;
                valid = false;
                this.getAuditErrors(header.getLabel()).add(new AuditError("PropDev-QuestionnairePage-" + StringUtils.removePattern((String)header.getLabel(), (String)"([^0-9a-zA-Z\\-_])"), "error.proposaldev.questionnaire.s2s.notcomplete", "PropDev-QuestionnairePage.PropDev-QuestionnairePage-" + StringUtils.removePattern((String)header.getLabel(), (String)"([^0-9a-zA-Z\\-_])"), new String[]{header.getLabel()}));
            }
        }
        return valid;
    }

    private synchronized ProposalDevelopmentS2sQuestionnaireService getProposalDevelopmentS2sQuestionnaireService() {
        if (this.proposalDevelopmentS2sQuestionnaireService == null) {
            this.proposalDevelopmentS2sQuestionnaireService = KcServiceLocator.getService(ProposalDevelopmentS2sQuestionnaireService.class);
        }
        return this.proposalDevelopmentS2sQuestionnaireService;
    }

    private List<AuditError> getAuditErrors(String sectionName) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String clusterKey = "Questionnaire." + sectionName;
        if (!GlobalVariables.getAuditErrorMap().containsKey(clusterKey)) {
            GlobalVariables.getAuditErrorMap().put(clusterKey, new AuditCluster(clusterKey, auditErrors, "Error"));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(clusterKey)).getAuditErrorList();
        }
        return auditErrors;
    }
}

