/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.workflow.LastActionService;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="lastActionService")
public class LastActionServiceImpl
implements LastActionService {
    private static final String KR_PRINCIPAL_ID = "1";
    @Autowired
    @Qualifier(value="kewWorkflowDocumentService")
    private WorkflowDocumentService workflowDocumentService;

    @Override
    public ActionTaken findLastUserActionTaken(String routeHeaderId) {
        if (StringUtils.isBlank((CharSequence)routeHeaderId)) {
            return null;
        }
        List actionsTaken = this.workflowDocumentService.getActionsTaken(routeHeaderId);
        if (actionsTaken != null) {
            return actionsTaken.stream().filter(actionTaken -> actionTaken != null).filter(actionTaken -> !actionTaken.getPrincipalId().equals(KR_PRINCIPAL_ID)).sorted(Comparator.comparing(ActionTaken::getActionDate).reversed()).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public String findLastUserActionTakenPrincipalId(String routeHeaderId) {
        ActionTaken at = this.findLastUserActionTaken(routeHeaderId);
        return at != null ? at.getPrincipalId() : null;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }
}

