/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.logging.controller;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.kuali.coeus.sys.impl.logging.controller.LogLevel;

final class LogLevels<T> {
    private final Map<LogLevel, T> systemToNative = new EnumMap<LogLevel, T>(LogLevel.class);
    private final Map<T, LogLevel> nativeToSystem = new HashMap<T, LogLevel>();

    public void map(LogLevel system, T nativeLevel) {
        this.systemToNative.putIfAbsent(system, nativeLevel);
        this.nativeToSystem.putIfAbsent(nativeLevel, system);
    }

    public LogLevel convertNativeToSystem(T level) {
        return this.nativeToSystem.get(level);
    }

    public T convertSystemToNative(LogLevel level) {
        return this.systemToNative.get((Object)level);
    }

    public Set<LogLevel> getSupported() {
        return new LinkedHashSet<LogLevel>(this.nativeToSystem.values());
    }
}

