/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.lookup.keyvalue;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.subaward.bo.DataSharing;
import org.kuali.kra.subaward.bo.SubAwardTemplateInfo;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class DataSharingFinder
extends FormViewAwareUifKeyValuesFinderBase {
    public List<KeyValue> getKeyValues() {
        SubAwardTemplateInfo info = ((SubAwardDocument)this.getDocument()).getSubAward().getSubAwardTemplateInfo().get(0);
        String selected = info != null ? info.getDataSharingCd() : "";
        boolean fdpViaPdfEnabled = this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", "Enable_FDP_Via_PDF_Service");
        Stream<KeyValue> optionStream = Arrays.stream(DataSharing.values()).filter(option -> this.shouldInclude((DataSharing)((Object)option), selected, fdpViaPdfEnabled)).map(option -> new ConcreteKeyValue(option.getCode(), option.getDescription())).sorted(Comparator.comparing(KeyValue::getValue));
        return Stream.concat(Stream.of(ValuesFinderUtils.getSelectOption()), optionStream).collect(Collectors.toList());
    }

    private boolean shouldInclude(DataSharing option, String selected, boolean fdpViaPdfEnabled) {
        if (fdpViaPdfEnabled) {
            return option != DataSharing.NOT_APPLICABLE || DataSharing.NOT_APPLICABLE.getCode().equals(selected);
        }
        return option != DataSharing.NO_ADDITIONAL_REQUIREMENTS || DataSharing.NO_ADDITIONAL_REQUIREMENTS.getCode().equals(selected);
    }

    protected ParameterService getParameterService() {
        return KcServiceLocator.getService(ParameterService.class);
    }
}

