/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingDao;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.ObjectUtils;

public class ReportTrackingDaoOjb
extends LookupDaoOjb
implements ReportTrackingDao {
    private static final Logger LOG = LogManager.getLogger(ReportTrackingDaoOjb.class);
    private static final Class<?> REPORT_TRACKING_CLASS = ReportTracking.class;
    private PersistenceStructureService persistenceStructureServiceLocal;

    @Override
    public CollectionIncomplete<ReportTracking> getRawResults(Map<String, String> searchValues) {
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new ReportTracking(), searchValues);
        criteria.addIn((Object)"awardId", this.getActiveAwardsSubQuery());
        QueryByCriteria query = QueryFactory.newQuery(REPORT_TRACKING_CLASS, (Criteria)criteria);
        long totalCount = 0L;
        Integer limit = LookupUtils.getSearchResultsLimit(REPORT_TRACKING_CLASS);
        if (limit != null && limit >= 0) {
            int matchingRows = this.getPersistenceBrokerTemplate().getCount((Query)query);
            if (matchingRows <= limit) {
                totalCount = matchingRows;
            }
            this.applySearchResultsLimit(REPORT_TRACKING_CLASS, criteria, this.getDbPlatform(), limit);
        }
        Collection results = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return new CollectionIncomplete(results, Long.valueOf(totalCount));
    }

    @Override
    public List<ReportTracking> getResultsGroupedBy(Map<String, String> searchValues, List<String> groupedByAttrs, List<String> displayByAttrs) throws IllegalAccessException, InvocationTargetException {
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new ReportTracking(), searchValues);
        criteria.addIn((Object)"awardId", this.getActiveAwardsSubQuery());
        ArrayList<String> columns = new ArrayList<String>(groupedByAttrs);
        columns.add("count(*)");
        ReportQueryByCriteria query = QueryFactory.newReportQuery(ReportTracking.class, (String[])columns.toArray(new String[1]), (Criteria)criteria, (boolean)true);
        query.addGroupBy(groupedByAttrs.toArray(new String[1]));
        for (String attr : groupedByAttrs) {
            query.addOrderByAscending(attr);
        }
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        ArrayList<ReportTracking> searchResults = new ArrayList<ReportTracking>();
        while (iter.hasNext()) {
            int i;
            Object[] curLine = (Object[])iter.next();
            ReportTracking curItem = new ReportTracking();
            for (i = 0; i < groupedByAttrs.size(); ++i) {
                String column = groupedByAttrs.get(i);
                if (curLine[i] == null) continue;
                if (ObjectUtils.getPropertyType((Object)curItem, (String)column, (PersistenceStructureService)this.persistenceStructureServiceLocal).isAssignableFrom(Timestamp.class) && curLine[i] instanceof Date) {
                    BeanUtils.setProperty((Object)curItem, (String)column, (Object)new Timestamp(((Date)curLine[i]).getTime()));
                    continue;
                }
                BeanUtils.setProperty((Object)curItem, (String)column, (Object)curLine[i]);
            }
            if (curLine[i] instanceof Long) {
                curItem.setItemCount(((Long)curLine[i]).intValue());
            } else {
                curItem.setItemCount(((BigDecimal)curLine[i]).intValue());
            }
            curItem.refreshNonUpdateableReferences();
            searchResults.add(curItem);
        }
        Collections.sort(searchResults, new MultiColumnComparator(displayByAttrs));
        return searchResults;
    }

    @Override
    public List<ReportTracking> getDetailResults(Map<String, String> searchValues, List<String> detailAttrs) throws IllegalAccessException, InvocationTargetException {
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new ReportTracking(), searchValues);
        criteria.addIn((Object)"awardId", this.getActiveAwardsSubQuery());
        QueryByCriteria query = QueryFactory.newQuery(ReportTracking.class, (Criteria)criteria, (boolean)false);
        ArrayList<ReportTracking> result = new ArrayList<ReportTracking>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query));
        Collections.sort(result, new MultiColumnComparator(detailAttrs));
        return result;
    }

    private Query getActiveAwardsSubQuery() {
        Criteria activeAwardSubCriteria = new Criteria();
        activeAwardSubCriteria.addIn("awardSequenceStatus", Arrays.asList(VersionStatus.ACTIVE.toString(), VersionStatus.PENDING.toString()));
        ReportQueryByCriteria activeAwardIdsQuery = QueryFactory.newReportQuery(Award.class, (Criteria)activeAwardSubCriteria);
        activeAwardIdsQuery.setAttributes(new String[]{"max(awardId)"});
        activeAwardIdsQuery.addGroupBy("awardNumber");
        return activeAwardIdsQuery;
    }

    protected PersistenceStructureService getPersistenceStructureServiceLocal() {
        return this.persistenceStructureServiceLocal;
    }

    public void setPersistenceStructureServiceLocal(PersistenceStructureService persistenceStructureServiceLocal) {
        this.persistenceStructureServiceLocal = persistenceStructureServiceLocal;
    }

    protected class MultiColumnComparator
    implements Comparator<ReportTracking> {
        private List<String> columnsToSortBy;

        public MultiColumnComparator(List<String> columnsToSortBy) {
            this.columnsToSortBy = columnsToSortBy;
        }

        @Override
        public int compare(ReportTracking o1, ReportTracking o2) {
            int result = 0;
            for (String column : this.columnsToSortBy) {
                String v1 = null;
                String v2 = null;
                try {
                    v1 = BeanUtils.getProperty((Object)o1, (String)column);
                    v2 = BeanUtils.getProperty((Object)o2, (String)column);
                }
                catch (Exception e) {
                    LOG.warn("Exception while trying to sort report tracking records.", (Throwable)e);
                }
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 == null && v2 != null) {
                    return -1;
                }
                if (v2 == null && v1 != null) {
                    return 1;
                }
                result = v1.compareTo(v2);
                if (result == 0) continue;
                break;
            }
            return result;
        }
    }
}

