/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.calculator;

import java.util.Calendar;
import java.util.Date;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class Boundary {
    private Date startDate;
    private Date endDate;
    private Calendar calendar = Calendar.getInstance();
    private DateTimeService dateTimeService;
    private ScaleTwoDecimal applicableCost;
    private ScaleTwoDecimal applicableCostSharing;

    public Boundary() {
        this.init();
    }

    protected void init() {
        this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
    }

    public Boundary(Date startDate, Date endDate) {
        this();
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public int getNumberOfDays() {
        return this.dateTimeService.dateDiff(this.getStartDate(), this.getEndDate(), true);
    }

    public int getStartDateMonth() {
        this.calendar.setTime(this.startDate);
        return this.calendar.get(2) + 1;
    }

    public int getStartDateTotalDays() {
        this.calendar.setTime(this.startDate);
        return this.calendar.getActualMaximum(5);
    }

    public int getStartDateRemainingDays() {
        this.calendar.setTime(this.startDate);
        return this.calendar.getActualMaximum(5) - this.calendar.get(5) + 1;
    }

    public int getEndDateMonth() {
        this.calendar.setTime(this.endDate);
        return this.calendar.get(2) + 1;
    }

    public int getEndDateTotalDays() {
        this.calendar.setTime(this.endDate);
        return this.calendar.getActualMaximum(5);
    }

    public int getEndDateNoOfDays() {
        this.calendar.setTime(this.endDate);
        return this.calendar.get(5);
    }

    public long getDateDifference() {
        return Math.round((double)(this.endDate.getTime() - this.startDate.getTime()) / 8.64E7 + 1.0);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String toString() {
        StringBuffer strBffr = new StringBuffer("");
        strBffr.append("Start date=>" + this.startDate);
        strBffr.append(";");
        strBffr.append("End date=>" + this.endDate);
        strBffr.append("\n");
        return strBffr.toString();
    }

    public ScaleTwoDecimal getApplicableCost() {
        return this.applicableCost == null ? ScaleTwoDecimal.ZERO : this.applicableCost;
    }

    public void setApplicableCost(ScaleTwoDecimal applicableCost) {
        this.applicableCost = applicableCost;
    }

    public ScaleTwoDecimal getApplicableCostSharing() {
        return this.applicableCostSharing;
    }

    public void setApplicableCostSharing(ScaleTwoDecimal applicableCostSharing) {
        this.applicableCostSharing = applicableCostSharing;
    }
}

