/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.nonpersonnel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.award.budget.AwardBudgetForm;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.springframework.stereotype.Component;

@Component(value="groupNameValuesFinder")
public class GroupNameValuesFinder
extends UifKeyValuesFinderBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        AwardBudgetForm budgetForm = (AwardBudgetForm)KNSGlobalVariables.getKualiForm();
        AwardBudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetPeriod curPeriod = null;
        Integer budgetPeriodNumber = budgetForm.getViewBudgetPeriod() == null ? 1 : budgetForm.getViewBudgetPeriod();
        for (BudgetPeriod period : budgetDocument.getBudget().getBudgetPeriods()) {
            if (!period.getBudgetPeriod().equals(budgetPeriodNumber)) continue;
            curPeriod = period;
            break;
        }
        keyValues.addAll(this.getKeyValues(curPeriod));
        return keyValues;
    }

    public List<KeyValue> getKeyValues(ViewModel model) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "Default"));
        BudgetPeriod budgetPeriod = ((ProposalBudgetForm)model).getAddProjectPersonnelHelper().getCurrentTabBudgetPeriod();
        keyValues.addAll(this.getKeyValues(budgetPeriod));
        keyValues.add((KeyValue)new ConcreteKeyValue("Create New Group", "Create New Group"));
        return keyValues;
    }

    public List<KeyValue> getKeyValues(BudgetPeriod budgetPeriod) {
        HashSet<String> distinctGroupNames = new HashSet<String>();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            boolean distinct;
            if (!StringUtils.isNotEmpty((CharSequence)budgetLineItem.getGroupName()) || !(distinct = distinctGroupNames.add(budgetLineItem.getGroupName()))) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(budgetLineItem.getGroupName(), budgetLineItem.getGroupName()));
        }
        return keyValues;
    }
}

