/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.sponsor;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.external.customercreation.CustomerConstants;
import org.kuali.kra.external.customercreation.CustomerCreationClient;
import org.kuali.kra.external.dunningcampaign.DunningCampaignClient;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.service.DataDictionaryService;

public class SponsorMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private CustomerCreationClient customerCreationClient;
    private DataDictionaryService dataDictionaryService;
    private DunningCampaignClient dunningCampaignClient;
    private ParameterService parameterService;

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkDunningCampaign(document) && this.checkCustomer(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkDunningCampaign(document) && this.checkCustomer(document);
    }

    protected boolean checkDunningCampaign(MaintenanceDocument document) {
        boolean valid = true;
        Sponsor sponsor = (Sponsor)document.getNewMaintainableObject().getDataObject();
        if (StringUtils.isNotBlank((CharSequence)sponsor.getDunningCampaignId()) && this.getParameterService().getParameterValueAsBoolean("KC-GEN", "Document", "FIN_SYSTEM_INTEGRATION_ON_SPONSOR").booleanValue() && this.getDunningCampaignClient().getDunningCampaign(sponsor.getDunningCampaignId()) == null) {
            String errorLabel = this.getDataDictionaryService().getAttributeErrorLabel(Sponsor.class, "dunningCampaignId");
            this.getGlobalVariableService().getMessageMap().putError("document.newMaintainableObject.dunningCampaignId", "error.missing", new String[]{errorLabel});
            valid = false;
        }
        return valid;
    }

    protected boolean checkCustomer(MaintenanceDocument document) {
        boolean valid = true;
        Sponsor sponsor = (Sponsor)document.getNewMaintainableObject().getDataObject();
        if (StringUtils.equals((CharSequence)sponsor.getCustomerExists(), (CharSequence)CustomerConstants.CustomerOptions.Types.EXISTING.getCode())) {
            if (this.getParameterService().getParameterValueAsBoolean("KC-GEN", "Document", "FIN_SYSTEM_INTEGRATION_ON_SPONSOR").booleanValue() && !this.getCustomerCreationClient().isValidCustomer(sponsor.getCustomerNumber())) {
                String errorLabel = this.getDataDictionaryService().getAttributeErrorLabel(Sponsor.class, "customerNumber");
                this.getGlobalVariableService().getMessageMap().putError("document.newMaintainableObject.customerNumber", "error.missing", new String[]{errorLabel});
                valid = false;
            }
        } else if (StringUtils.equals((CharSequence)sponsor.getCustomerExists(), (CharSequence)CustomerConstants.CustomerOptions.Types.NEW.getCode()) && StringUtils.isBlank((CharSequence)sponsor.getCustomerTypeCode())) {
            String errorLabel = this.getDataDictionaryService().getAttributeErrorLabel(Sponsor.class, "customerTypeCode");
            this.getGlobalVariableService().getMessageMap().putError("document.newMaintainableObject.customerTypeCode", "error.missing", new String[]{errorLabel});
            valid = false;
        } else if (StringUtils.equals((CharSequence)sponsor.getCustomerExists(), (CharSequence)CustomerConstants.CustomerOptions.Types.NO.getCode()) && !StringUtils.isBlank((CharSequence)sponsor.getCustomerNumber()) && !StringUtils.isBlank((CharSequence)sponsor.getCustomerTypeCode())) {
            String errorLabel = this.getDataDictionaryService().getAttributeErrorLabel(Sponsor.class, "customerExists");
            this.getGlobalVariableService().getMessageMap().putError("document.newMaintainableObject.customerExists", "error.missing", new String[]{errorLabel});
            valid = false;
        }
        return valid;
    }

    public CustomerCreationClient getCustomerCreationClient() {
        if (this.customerCreationClient == null) {
            this.customerCreationClient = KcServiceLocator.getService(CustomerCreationClient.class);
        }
        return this.customerCreationClient;
    }

    public void setCustomerCreationClient(CustomerCreationClient customerCreationClient) {
        this.customerCreationClient = customerCreationClient;
    }

    public DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KcServiceLocator.getService(DataDictionaryService.class);
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DunningCampaignClient getDunningCampaignClient() {
        if (this.dunningCampaignClient == null) {
            this.dunningCampaignClient = KcServiceLocator.getService(DunningCampaignClient.class);
        }
        return this.dunningCampaignClient;
    }

    public void setDunningCampaignClient(DunningCampaignClient dunningCampaignClient) {
        this.dunningCampaignClient = dunningCampaignClient;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

