/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardAuditRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private static final String CONTACTS_AUDIT_ERRORS = "contactsAuditErrors";
    private List<AuditError> auditErrors = new ArrayList<AuditError>();

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        this.auditErrors = new ArrayList<AuditError>();
        this.reportAndCreateAuditCluster();
        return valid &= this.checkForAtLeastOneContact(document);
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            AuditCluster existingErrors = (AuditCluster)GlobalVariables.getAuditErrorMap().get(CONTACTS_AUDIT_ERRORS);
            if (existingErrors == null) {
                GlobalVariables.getAuditErrorMap().put(CONTACTS_AUDIT_ERRORS, new AuditCluster("Contacts", this.auditErrors, "Error"));
            } else {
                existingErrors.getAuditErrorList().addAll(this.auditErrors);
            }
        }
    }

    protected boolean checkForAtLeastOneContact(Document document) {
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        subAwardDocument.getSubAward().getSubAwardContactsList().size();
        if (subAwardDocument.getSubAward().getSubAwardContactsList().size() <= 0) {
            subAwardDocument.getSubAward().setDefaultOpen(false);
            this.auditErrors.add(new AuditError("newSubAwardContact.rolodex.fullName", "subaward.contact.not.added", "subAward.Contacts"));
            return false;
        }
        subAwardDocument.getSubAward().setDefaultOpen(true);
        return true;
    }
}

