/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="costElementValuesFinder")
public class CostElementValuesFinder
extends UifKeyValuesFinderBase {
    public static final String BUDGET_CATEGORY_CODE = "budgetCategory.code";
    public static final String BUDGET_CATEGORY_BUDGET_CATEGORY_TYPE_CODE = "budgetCategory.budgetCategoryTypeCode";
    public static final String UNIT_NUMBER = "unitNumber";
    @Autowired
    @Qualifier(value="dataObjectService")
    DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="unitService")
    UnitService unitService;
    private String budgetCategoryTypeCode;
    private String unitNumber;

    public List<KeyValue> getKeyValues() {
        return this.getKeyValues(this.getBudgetCategoryTypeCode(), true, null, this.getUnitNumber());
    }

    public List<KeyValue> getKeyValues(String budgetCategoryTypeCode, boolean budgetCategoryTypeCodeEqual, String budgetCategoryCode, String unitNumber) {
        return this.getCostElementKeyValues(budgetCategoryTypeCode, budgetCategoryTypeCodeEqual, budgetCategoryCode, unitNumber);
    }

    protected List<KeyValue> getCostElementKeyValues(String budgetCategoryTypeCode, boolean budgetCategoryTypeCodeEqual, String budgetCategoryCode, String unitNumber) {
        List<CostElement> costElements = new ArrayList<CostElement>();
        Unit unit = this.getUnitService().getUnit(unitNumber);
        while (costElements.isEmpty() && unit != null) {
            costElements = this.getMatchingResults(budgetCategoryTypeCode, budgetCategoryTypeCodeEqual, budgetCategoryCode, unit);
            unit = this.getUnitService().getUnit(unit.getUnitNumber()).getParentUnit();
        }
        costElements = this.ifNoUnitsMappedGetAll(budgetCategoryTypeCode, budgetCategoryTypeCodeEqual, budgetCategoryCode, costElements);
        return this.getDropDownDisplay(costElements);
    }

    protected List<CostElement> getMatchingResults(String budgetCategoryTypeCode, boolean budgetCategoryTypeCodeEqual, String budgetCategoryCode, Unit unit) {
        return this.getDataObjectService().findMatching(CostElement.class, QueryByCriteria.Builder.fromPredicates(this.getPredicates(budgetCategoryTypeCode, budgetCategoryTypeCodeEqual, budgetCategoryCode, unit == null ? null : unit.getUnitNumber()))).getResults();
    }

    private List<CostElement> ifNoUnitsMappedGetAll(String budgetCategoryTypeCode, boolean budgetCategoryTypeCodeEqual, String budgetCategoryCode, List<CostElement> costElements) {
        if (costElements.isEmpty()) {
            costElements = this.getMatchingResults(budgetCategoryTypeCode, budgetCategoryTypeCodeEqual, budgetCategoryCode, null);
        }
        return costElements;
    }

    protected List<KeyValue> getDropDownDisplay(List<CostElement> costElements) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (CostElement costElement : costElements) {
            keyValues.add((KeyValue)new ConcreteKeyValue(costElement.getCostElement(), costElement.getDescription()));
        }
        Collections.sort(keyValues, new KeyValueComparator());
        keyValues.add(0, ValuesFinderUtils.getSelectOption());
        return keyValues;
    }

    protected List<Predicate> getPredicates(String budgetCategoryTypeCode, boolean budgetCategoryTypeCodeEqual, String budgetCategoryCode, String unitNumber) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)"active", (Object)Boolean.TRUE));
        if (!StringUtils.isBlank((CharSequence)budgetCategoryTypeCode)) {
            if (budgetCategoryTypeCodeEqual) {
                predicates.add(PredicateFactory.equal((String)BUDGET_CATEGORY_BUDGET_CATEGORY_TYPE_CODE, (Object)budgetCategoryTypeCode));
            } else {
                predicates.add(PredicateFactory.notEqual((String)BUDGET_CATEGORY_BUDGET_CATEGORY_TYPE_CODE, (Object)budgetCategoryTypeCode));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)budgetCategoryCode)) {
            predicates.add(PredicateFactory.equal((String)BUDGET_CATEGORY_CODE, (Object)budgetCategoryCode));
        }
        if (StringUtils.isNotEmpty((CharSequence)unitNumber)) {
            predicates.add(PredicateFactory.equal((String)UNIT_NUMBER, (Object)unitNumber));
        }
        return predicates;
    }

    public String getBudgetCategoryTypeCode() {
        return this.budgetCategoryTypeCode;
    }

    public void setBudgetCategoryTypeCode(String budgetCategoryTypeCode) {
        this.budgetCategoryTypeCode = budgetCategoryTypeCode;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    class KeyValueComparator
    implements Comparator<KeyValue> {
        KeyValueComparator() {
        }

        @Override
        public int compare(KeyValue o1, KeyValue o2) {
            return o1.getValue().compareToIgnoreCase(o2.getValue());
        }
    }
}

