/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kuali.coeus.sys.framework.keyvalue.KeyValueComparator;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;

public class ExconCountryCodeValuesFinder
extends UifKeyValuesFinderBase {
    private CountryService countryService;

    public List<KeyValue> getKeyValues() {
        List countries = this.getCountryService().findAllCountries();
        Country defaultCountry = this.getCountryService().getDefaultCountry();
        List<KeyValue> keyValues = countries.stream().filter(Objects::nonNull).filter(country -> Objects.nonNull(country.getAlternateCode())).filter(country -> Objects.nonNull(country.getName())).map(country -> new ConcreteKeyValue(country.getAlternateCode(), country.getName())).sorted(KeyValueComparator.getInstance()).collect(Collectors.toList());
        if (defaultCountry != null && defaultCountry.getAlternateCode() != null && defaultCountry.getName() != null) {
            keyValues.add(0, (KeyValue)new ConcreteKeyValue(defaultCountry.getAlternateCode(), defaultCountry.getName()));
        }
        if (this.isAddBlankOption()) {
            keyValues.add(0, (KeyValue)new ConcreteKeyValue("", "(select)"));
        }
        return keyValues;
    }

    public CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = KcServiceLocator.getService(CountryService.class);
        }
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }
}

