/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.specialreview;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.framework.print.KcAttachmentDataSource;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewAttachmentContract;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewHumanSubjectsAttachmentService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.web.bind.RequestAccessible;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="EPS_PROP_SPL_REVIEW_ATTACHMENT")
public class ProposalSpecialReviewAttachment
extends KcAttachmentDataSource
implements ProposalSpecialReviewAttachmentContract {
    @PortableSequenceGenerator(name="SEQ_EPS_PROP_SPL_RVW_ATT_ID")
    @GeneratedValue(generator="SEQ_EPS_PROP_SPL_RVW_ATT_ID")
    @Id
    @Column(name="PROPOSAL_SPECIAL_REVIEW_ATT_ID")
    private Long id;
    @Column(name="CLINICAL_TRIAL")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean clinicalTrial;
    @Column(name="STUDY_TITLE")
    private String studyTitle;
    @Column(name="IS_ATTACHMENT_DELAYED_ONSET")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean isAttachmentDelayedOnset;
    @RequestAccessible
    @Transient
    private transient MultipartFile multipartFile;
    @Transient
    private transient SoftReference<String> attachmentXmlFileData;
    @Transient
    private transient ProposalSpecialReviewHumanSubjectsAttachmentService proposalSpecialReviewHumanSubjectsAttachmentService;
    @Transient
    private transient GlobalVariableService globalVariableService;
    @Transient
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public void init(MultipartFile multipartFile) throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            this.setType(multipartFile.getContentType());
            this.setData(multipartFile.getBytes());
            this.setName(multipartFile.getOriginalFilename());
        }
    }

    public MultipartFile getMultipartFile() {
        return this.multipartFile;
    }

    public void setMultipartFile(MultipartFile multipartFile) {
        if (multipartFile != null && !multipartFile.isEmpty()) {
            this.multipartFile = multipartFile;
            this.initialized.set(false);
        }
    }

    public Boolean isAttachmentDelayedOnset() {
        return this.isAttachmentDelayedOnset;
    }

    public Boolean getIsAttachmentDelayedOnset() {
        return this.isAttachmentDelayedOnset;
    }

    public void setIsAttachmentDelayedOnset(Boolean isAttachmentDelayedOnset) {
        this.isAttachmentDelayedOnset = isAttachmentDelayedOnset;
    }

    public void setClinicalTrial(Boolean clinicalTrial) {
        this.clinicalTrial = clinicalTrial;
    }

    public String getStudyTitle() {
        return this.studyTitle;
    }

    public Boolean getClinicalTrial() {
        return this.clinicalTrial;
    }

    public void setStudyTitle(String studyTitle) {
        this.studyTitle = studyTitle;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SoftReference<String> getAttachmentXmlFileData() {
        return this.attachmentXmlFileData;
    }

    public void setAttachmentXmlFileData(SoftReference<String> attachmentXmlFileData) {
        this.attachmentXmlFileData = attachmentXmlFileData;
    }

    public Map<String, Object> getSpecialReviewAttachmentXmlFileData() {
        return this.getAttachmentService().getSpecialReviewAttachmentXmlFileData(this.getData());
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public ProposalSpecialReviewHumanSubjectsAttachmentService getAttachmentService() {
        if (this.proposalSpecialReviewHumanSubjectsAttachmentService == null) {
            this.proposalSpecialReviewHumanSubjectsAttachmentService = KcServiceLocator.getService(ProposalSpecialReviewHumanSubjectsAttachmentService.class);
        }
        return this.proposalSpecialReviewHumanSubjectsAttachmentService;
    }
}

