/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.util.GlobalVariables;

public class UnitMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    public static final String DOCUMENT_PARENT_UNIT_NUMBER = "document.newMaintainableObject.parentUnitNumber";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.moveUnit(document) && this.isValidParentUnit(document);
    }

    public boolean isValidParentUnit(MaintenanceDocument document) {
        UnitService unitService;
        Unit topUnit;
        Unit unit = (Unit)document.getNewMaintainableObject().getDataObject();
        if (unit != null && unit.getParentUnitNumber() == null && (topUnit = (unitService = this.getUnitService()).getTopUnit()) != null && !topUnit.getUnitNumber().equalsIgnoreCase(unit.getUnitNumber())) {
            GlobalVariables.getMessageMap().putError(DOCUMENT_PARENT_UNIT_NUMBER, "error.required.parent.unit", new String[0]);
            return false;
        }
        return true;
    }

    public UnitService getUnitService() {
        return KcServiceLocator.getService(UnitService.class);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.moveUnit(document);
    }

    private boolean moveUnit(MaintenanceDocument maintenanceDocument) {
        String parentUnitNumber;
        boolean valid = true;
        Unit unit = (Unit)maintenanceDocument.getNewMaintainableObject().getDataObject();
        String unitNumber = unit.getUnitNumber();
        if (StringUtils.equals((CharSequence)unitNumber, (CharSequence)(parentUnitNumber = unit.getParentUnitNumber()))) {
            GlobalVariables.getMessageMap().putError(DOCUMENT_PARENT_UNIT_NUMBER, "error.same.as.parent", new String[0]);
            valid = false;
        }
        List<Unit> allSubUnits = this.getUnitService().getAllSubUnits(unitNumber);
        for (Unit subunits : allSubUnits) {
            if (!subunits.getUnitNumber().equals(parentUnitNumber)) continue;
            GlobalVariables.getMessageMap().putError(DOCUMENT_PARENT_UNIT_NUMBER, "error_move_unit", new String[]{unit.getParentUnitNumber(), unit.getParentUnitNumber()});
            valid = false;
        }
        return valid;
    }
}

