/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.auth.perm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocValue;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.propdev.impl.attachment.LegacyNarrativeService;
import org.kuali.coeus.propdev.impl.auth.perm.ProposalDevelopmentPermissionsService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.docperm.AddProposalUserEvent;
import org.kuali.coeus.propdev.impl.docperm.DeleteProposalUserEvent;
import org.kuali.coeus.propdev.impl.docperm.EditUserProposalRolesEvent;
import org.kuali.coeus.propdev.impl.docperm.ProposalRoleService;
import org.kuali.coeus.propdev.impl.docperm.ProposalUserRoles;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentPermissionsService")
public class ProposalDevelopmentPermissionsServiceImpl
implements ProposalDevelopmentPermissionsService {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentPermissionsServiceImpl.class);
    public static final String COI_REQUIREMENT = "COI_REQUIREMENT";
    public static final String PRINCIPAL_COI_KEY_PERSON = "PCK";
    public static final int HIERARCHY_LEVEL = 1;
    private static final String PARAMETER_DELIMITER = "\\s*,\\s*";
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kraAuthorizationService;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="kualiRuleService")
    private KualiRuleService kualiRuleService;
    @Autowired
    @Qualifier(value="legacyNarrativeService")
    private LegacyNarrativeService narrativeService;
    @Autowired
    @Qualifier(value="proposalRoleService")
    private ProposalRoleService proposalRoleService;

    @Override
    public List<ProposalUserRoles> getPermissions(ProposalDevelopmentDocument document) {
        TreeMap<String, ProposalUserRoles> pendingRoleMap = new TreeMap<String, ProposalUserRoles>();
        List<Role> roles = this.proposalRoleService.getRolesForDisplay();
        for (Role role : roles) {
            List<String> personIds = this.kraAuthorizationService.getPrincipalsInRole(role.getName(), document);
            for (String personId : personIds) {
                KcPerson person = this.getKcPersonService().getKcPersonByPersonId(personId);
                if (person != null) {
                    ProposalUserRoles proposalUserRole = (ProposalUserRoles)pendingRoleMap.get(person.getUserName());
                    if (proposalUserRole != null) {
                        proposalUserRole.addRoleName(role.getName());
                        continue;
                    }
                    ProposalUserRoles newRole = new ProposalUserRoles();
                    newRole.setUsername(person.getUserName());
                    newRole.setFullname(person.getFullName());
                    newRole.addRoleName(role.getName());
                    pendingRoleMap.put(person.getUserName(), newRole);
                    continue;
                }
                LOG.error("Attempting to get roles for null user role!");
            }
        }
        return new ArrayList<ProposalUserRoles>(pendingRoleMap.values());
    }

    @Override
    public void savePermissions(ProposalDevelopmentDocument document, List<ProposalUserRoles> persistedUsers, List<ProposalUserRoles> newUsers) {
        ArrayList<ProposalUserRoles> proposalUsersToDelete = new ArrayList<ProposalUserRoles>(persistedUsers);
        proposalUsersToDelete.removeAll(newUsers);
        for (ProposalUserRoles proposalUser : proposalUsersToDelete) {
            this.deleteProposalUser(proposalUser, document);
        }
        ArrayList<ProposalUserRoles> proposalUsersToAdd = new ArrayList<ProposalUserRoles>(newUsers);
        proposalUsersToAdd.removeAll(persistedUsers);
        for (ProposalUserRoles proposalUser : proposalUsersToAdd) {
            this.saveProposalUser(proposalUser, document);
        }
    }

    public void deleteProposalUser(ProposalUserRoles proposalUser, ProposalDevelopmentDocument doc) {
        List<String> roleNames = proposalUser.getRoleNames();
        for (String roleName : roleNames) {
            this.kraAuthorizationService.removeDocumentLevelRole(this.getPersonId(proposalUser.getUsername()), roleName, doc);
        }
    }

    protected String getPersonId(String username) {
        Person person = this.personService.getPersonByPrincipalName(username);
        return person.getPrincipalId();
    }

    public void saveProposalUser(ProposalUserRoles proposalUser, ProposalDevelopmentDocument doc) {
        List<String> roleNames = proposalUser.getRoleNames();
        for (String roleName : roleNames) {
            this.kraAuthorizationService.addDocumentLevelRole(this.getPersonId(proposalUser.getUsername()), roleName, doc);
        }
    }

    @Override
    public boolean hasCertificationPermissions(ProposalDevelopmentDocument document, Person user, ProposalPerson proposalPerson) {
        return this.canCertify(user.getPrincipalId(), proposalPerson, this.canProxyCertify(document, user));
    }

    protected boolean canCertify(String userPrincipalId, ProposalPerson proposalPerson, boolean canProxyCertify) {
        return !(!canProxyCertify && !this.proposalPersonIsUser(userPrincipalId, proposalPerson) || !proposalPerson.needsCertification() && proposalPerson.getOptInCertificationStatus() != false);
    }

    @Override
    public boolean isKeyPersonRoleExempt(ProposalPerson proposalPerson) {
        return this.getExemptKeyPersonRoles().stream().anyMatch(projectRole -> projectRole.equalsIgnoreCase(proposalPerson.getProjectRole()));
    }

    @Override
    public boolean doesSponsorRequireKeyPersonCertification(ProposalPerson proposalPerson) {
        String sponsorHierarchy = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "COIHierarchyName");
        String sponsorHierarchyLevelName = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "COIHierarchyLevel1");
        return this.getSponsorHierarchyService().isSponsorInHierarchy(proposalPerson.getDevelopmentProposal().getSponsorCode(), sponsorHierarchy, 1, sponsorHierarchyLevelName);
    }

    protected List<String> getExemptKeyPersonRoles() {
        String keyPersonProjectRoles = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "keyPersonProjectRole");
        List<String> keyPersonRoleList = StringUtils.isEmpty((CharSequence)keyPersonProjectRoles) ? Collections.emptyList() : Arrays.asList(keyPersonProjectRoles.split(PARAMETER_DELIMITER));
        return keyPersonRoleList;
    }

    protected boolean proposalPersonIsUser(String userPrincipalId, ProposalPerson proposalPerson) {
        return proposalPerson.isNonEmployee() ? false : proposalPerson.getPersonId().equals(userPrincipalId);
    }

    protected boolean canProxyCertify(ProposalDevelopmentDocument document, Person user) {
        return this.getKraAuthorizationService().hasPermission(user.getPrincipalId(), document, "Certify");
    }

    @Override
    public boolean isPiCoiKeyPersonsForcedToDiscloseWithCustomData(DevelopmentProposal developmentProposal) {
        try {
            List<CustomAttributeDocValue> customDataList = developmentProposal.getProposalDocument().getCustomDataList();
            for (CustomAttributeDocValue attributeDocValue : customDataList) {
                if (!attributeDocValue.getCustomAttribute().getName().equalsIgnoreCase(COI_REQUIREMENT) || !PRINCIPAL_COI_KEY_PERSON.equals(attributeDocValue.getValue())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            LOG.warn(exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    @Override
    public boolean validateAddPermissions(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUserRolesList, ProposalUserRoles proposalUser) {
        return this.getKualiRuleService().applyRules((DocumentEvent)new AddProposalUserEvent(document, proposalUserRolesList, proposalUser));
    }

    @Override
    public boolean validateDeletePermissions(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUserRolesList, int index) {
        return this.getKualiRuleService().applyRules((DocumentEvent)new DeleteProposalUserEvent(document, proposalUserRolesList, index));
    }

    @Override
    public boolean validateUpdatePermissions(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUserRolesList, ProposalUserRoles proposalUser) {
        return this.getKualiRuleService().applyRules((DocumentEvent)new EditUserProposalRolesEvent(document, proposalUserRolesList, proposalUser));
    }

    @Override
    public void processAddPermission(ProposalDevelopmentDocument document, ProposalUserRoles proposalUser) {
        this.getNarrativeService().addPerson(proposalUser.getUsername(), document, proposalUser.getRoleNames());
    }

    @Override
    public void processDeletePermission(ProposalDevelopmentDocument document, ProposalUserRoles proposalUser) {
        this.getNarrativeService().deletePerson(this.getPersonService().getPersonByPrincipalName(proposalUser.getUsername()).getPrincipalId(), document);
    }

    @Override
    public void processUpdatePermission(ProposalDevelopmentDocument document, ProposalUserRoles proposalUser) {
        this.getNarrativeService().readjustRights(this.getPersonId(proposalUser.getUsername()), document, proposalUser.getRoleNames());
    }

    public KcAuthorizationService getKraAuthorizationService() {
        return this.kraAuthorizationService;
    }

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public LegacyNarrativeService getNarrativeService() {
        return this.narrativeService;
    }

    public void setNarrativeService(LegacyNarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }
}

